package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListValueAdded invokes the ddoscoo.ListValueAdded API synchronously
func (client *Client) ListValueAdded(request *ListValueAddedRequest) (response *ListValueAddedResponse, err error) {
	response = CreateListValueAddedResponse()
	err = client.DoAction(request, response)
	return
}

// ListValueAddedWithChan invokes the ddoscoo.ListValueAdded API asynchronously
func (client *Client) ListValueAddedWithChan(request *ListValueAddedRequest) (<-chan *ListValueAddedResponse, <-chan error) {
	responseChan := make(chan *ListValueAddedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListValueAdded(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListValueAddedWithCallback invokes the ddoscoo.ListValueAdded API asynchronously
func (client *Client) ListValueAddedWithCallback(request *ListValueAddedRequest, callback func(response *ListValueAddedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListValueAddedResponse
		var err error
		defer close(result)
		response, err = client.ListValueAdded(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListValueAddedRequest is the request struct for api ListValueAdded
type ListValueAddedRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
}

// ListValueAddedResponse is the response struct for api ListValueAdded
type ListValueAddedResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	ValueAddedList []ValueAdded `json:"ValueAddedList" xml:"ValueAddedList"`
}

// CreateListValueAddedRequest creates a request to invoke ListValueAdded API
func CreateListValueAddedRequest() (request *ListValueAddedRequest) {
	request = &ListValueAddedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ListValueAdded", "", "")
	request.Method = requests.POST
	return
}

// CreateListValueAddedResponse creates a response to parse from ListValueAdded response
func CreateListValueAddedResponse() (response *ListValueAddedResponse) {
	response = &ListValueAddedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
