package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSparkJobDriverLog invokes the dms_enterprise.GetSparkJobDriverLog API synchronously
func (client *Client) GetSparkJobDriverLog(request *GetSparkJobDriverLogRequest) (response *GetSparkJobDriverLogResponse, err error) {
	response = CreateGetSparkJobDriverLogResponse()
	err = client.DoAction(request, response)
	return
}

// GetSparkJobDriverLogWithChan invokes the dms_enterprise.GetSparkJobDriverLog API asynchronously
func (client *Client) GetSparkJobDriverLogWithChan(request *GetSparkJobDriverLogRequest) (<-chan *GetSparkJobDriverLogResponse, <-chan error) {
	responseChan := make(chan *GetSparkJobDriverLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSparkJobDriverLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSparkJobDriverLogWithCallback invokes the dms_enterprise.GetSparkJobDriverLog API asynchronously
func (client *Client) GetSparkJobDriverLogWithCallback(request *GetSparkJobDriverLogRequest, callback func(response *GetSparkJobDriverLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSparkJobDriverLogResponse
		var err error
		defer close(result)
		response, err = client.GetSparkJobDriverLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSparkJobDriverLogRequest is the request struct for api GetSparkJobDriverLog
type GetSparkJobDriverLogRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetSparkJobDriverLogResponse is the response struct for api GetSparkJobDriverLog
type GetSparkJobDriverLogResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	DriverLog    string `json:"DriverLog" xml:"DriverLog"`
}

// CreateGetSparkJobDriverLogRequest creates a request to invoke GetSparkJobDriverLog API
func CreateGetSparkJobDriverLogRequest() (request *GetSparkJobDriverLogRequest) {
	request = &GetSparkJobDriverLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetSparkJobDriverLog", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSparkJobDriverLogResponse creates a response to parse from GetSparkJobDriverLog response
func CreateGetSparkJobDriverLogResponse() (response *GetSparkJobDriverLogResponse) {
	response = &GetSparkJobDriverLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
