package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForUpdateProhibitionLock invokes the domain.SaveSingleTaskForUpdateProhibitionLock API synchronously
func (client *Client) SaveSingleTaskForUpdateProhibitionLock(request *SaveSingleTaskForUpdateProhibitionLockRequest) (response *SaveSingleTaskForUpdateProhibitionLockResponse, err error) {
	response = CreateSaveSingleTaskForUpdateProhibitionLockResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForUpdateProhibitionLockWithChan invokes the domain.SaveSingleTaskForUpdateProhibitionLock API asynchronously
func (client *Client) SaveSingleTaskForUpdateProhibitionLockWithChan(request *SaveSingleTaskForUpdateProhibitionLockRequest) (<-chan *SaveSingleTaskForUpdateProhibitionLockResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForUpdateProhibitionLockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForUpdateProhibitionLock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForUpdateProhibitionLockWithCallback invokes the domain.SaveSingleTaskForUpdateProhibitionLock API asynchronously
func (client *Client) SaveSingleTaskForUpdateProhibitionLockWithCallback(request *SaveSingleTaskForUpdateProhibitionLockRequest, callback func(response *SaveSingleTaskForUpdateProhibitionLockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForUpdateProhibitionLockResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForUpdateProhibitionLock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForUpdateProhibitionLockRequest is the request struct for api SaveSingleTaskForUpdateProhibitionLock
type SaveSingleTaskForUpdateProhibitionLockRequest struct {
	*requests.RpcRequest
	DomainName   string           `position:"Query" name:"DomainName"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	Lang         string           `position:"Query" name:"Lang"`
	Status       requests.Boolean `position:"Query" name:"Status"`
}

// SaveSingleTaskForUpdateProhibitionLockResponse is the response struct for api SaveSingleTaskForUpdateProhibitionLock
type SaveSingleTaskForUpdateProhibitionLockResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForUpdateProhibitionLockRequest creates a request to invoke SaveSingleTaskForUpdateProhibitionLock API
func CreateSaveSingleTaskForUpdateProhibitionLockRequest() (request *SaveSingleTaskForUpdateProhibitionLockRequest) {
	request = &SaveSingleTaskForUpdateProhibitionLockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForUpdateProhibitionLock", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForUpdateProhibitionLockResponse creates a response to parse from SaveSingleTaskForUpdateProhibitionLock response
func CreateSaveSingleTaskForUpdateProhibitionLockResponse() (response *SaveSingleTaskForUpdateProhibitionLockResponse) {
	response = &SaveSingleTaskForUpdateProhibitionLockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
