package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRootStacks invokes the edas.ListRootStacks API synchronously
func (client *Client) ListRootStacks(request *ListRootStacksRequest) (response *ListRootStacksResponse, err error) {
	response = CreateListRootStacksResponse()
	err = client.DoAction(request, response)
	return
}

// ListRootStacksWithChan invokes the edas.ListRootStacks API asynchronously
func (client *Client) ListRootStacksWithChan(request *ListRootStacksRequest) (<-chan *ListRootStacksResponse, <-chan error) {
	responseChan := make(chan *ListRootStacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRootStacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRootStacksWithCallback invokes the edas.ListRootStacks API asynchronously
func (client *Client) ListRootStacksWithCallback(request *ListRootStacksRequest, callback func(response *ListRootStacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRootStacksResponse
		var err error
		defer close(result)
		response, err = client.ListRootStacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRootStacksRequest is the request struct for api ListRootStacks
type ListRootStacksRequest struct {
	*requests.RoaRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// ListRootStacksResponse is the response struct for api ListRootStacks
type ListRootStacksResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Message   string               `json:"Message" xml:"Message"`
	Code      int                  `json:"Code" xml:"Code"`
	Data      DataInListRootStacks `json:"Data" xml:"Data"`
}

// CreateListRootStacksRequest creates a request to invoke ListRootStacks API
func CreateListRootStacksRequest() (request *ListRootStacksRequest) {
	request = &ListRootStacksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListRootStacks", "/pop/v5/s2i/list_root_stack", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListRootStacksResponse creates a response to parse from ListRootStacks response
func CreateListRootStacksResponse() (response *ListRootStacksResponse) {
	response = &ListRootStacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
