package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSchedulerInfo invokes the ehpc.GetSchedulerInfo API synchronously
func (client *Client) GetSchedulerInfo(request *GetSchedulerInfoRequest) (response *GetSchedulerInfoResponse, err error) {
	response = CreateGetSchedulerInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetSchedulerInfoWithChan invokes the ehpc.GetSchedulerInfo API asynchronously
func (client *Client) GetSchedulerInfoWithChan(request *GetSchedulerInfoRequest) (<-chan *GetSchedulerInfoResponse, <-chan error) {
	responseChan := make(chan *GetSchedulerInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSchedulerInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSchedulerInfoWithCallback invokes the ehpc.GetSchedulerInfo API asynchronously
func (client *Client) GetSchedulerInfoWithCallback(request *GetSchedulerInfoRequest, callback func(response *GetSchedulerInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSchedulerInfoResponse
		var err error
		defer close(result)
		response, err = client.GetSchedulerInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSchedulerInfoRequest is the request struct for api GetSchedulerInfo
type GetSchedulerInfoRequest struct {
	*requests.RpcRequest
	ClusterId string                       `position:"Query" name:"ClusterId"`
	Scheduler *[]GetSchedulerInfoScheduler `position:"Query" name:"Scheduler"  type:"Repeated"`
}

// GetSchedulerInfoScheduler is a repeated param struct in GetSchedulerInfoRequest
type GetSchedulerInfoScheduler struct {
	SchedName string `name:"SchedName"`
}

// GetSchedulerInfoResponse is the response struct for api GetSchedulerInfo
type GetSchedulerInfoResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	SchedInfo []SchedInfoItem `json:"SchedInfo" xml:"SchedInfo"`
}

// CreateGetSchedulerInfoRequest creates a request to invoke GetSchedulerInfo API
func CreateGetSchedulerInfoRequest() (request *GetSchedulerInfoRequest) {
	request = &GetSchedulerInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetSchedulerInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetSchedulerInfoResponse creates a response to parse from GetSchedulerInfo response
func CreateGetSchedulerInfoResponse() (response *GetSchedulerInfoResponse) {
	response = &GetSchedulerInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
