package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseAnycastEipAddress invokes the eipanycast.ReleaseAnycastEipAddress API synchronously
func (client *Client) ReleaseAnycastEipAddress(request *ReleaseAnycastEipAddressRequest) (response *ReleaseAnycastEipAddressResponse, err error) {
	response = CreateReleaseAnycastEipAddressResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseAnycastEipAddressWithChan invokes the eipanycast.ReleaseAnycastEipAddress API asynchronously
func (client *Client) ReleaseAnycastEipAddressWithChan(request *ReleaseAnycastEipAddressRequest) (<-chan *ReleaseAnycastEipAddressResponse, <-chan error) {
	responseChan := make(chan *ReleaseAnycastEipAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseAnycastEipAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseAnycastEipAddressWithCallback invokes the eipanycast.ReleaseAnycastEipAddress API asynchronously
func (client *Client) ReleaseAnycastEipAddressWithCallback(request *ReleaseAnycastEipAddressRequest, callback func(response *ReleaseAnycastEipAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseAnycastEipAddressResponse
		var err error
		defer close(result)
		response, err = client.ReleaseAnycastEipAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseAnycastEipAddressRequest is the request struct for api ReleaseAnycastEipAddress
type ReleaseAnycastEipAddressRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	AnycastId   string `position:"Query" name:"AnycastId"`
}

// ReleaseAnycastEipAddressResponse is the response struct for api ReleaseAnycastEipAddress
type ReleaseAnycastEipAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseAnycastEipAddressRequest creates a request to invoke ReleaseAnycastEipAddress API
func CreateReleaseAnycastEipAddressRequest() (request *ReleaseAnycastEipAddressRequest) {
	request = &ReleaseAnycastEipAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "ReleaseAnycastEipAddress", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseAnycastEipAddressResponse creates a response to parse from ReleaseAnycastEipAddress response
func CreateReleaseAnycastEipAddressResponse() (response *ReleaseAnycastEipAddressResponse) {
	response = &ReleaseAnycastEipAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
