package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseHttps invokes the elasticsearch.CloseHttps API synchronously
func (client *Client) CloseHttps(request *CloseHttpsRequest) (response *CloseHttpsResponse, err error) {
	response = CreateCloseHttpsResponse()
	err = client.DoAction(request, response)
	return
}

// CloseHttpsWithChan invokes the elasticsearch.CloseHttps API asynchronously
func (client *Client) CloseHttpsWithChan(request *CloseHttpsRequest) (<-chan *CloseHttpsResponse, <-chan error) {
	responseChan := make(chan *CloseHttpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseHttps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseHttpsWithCallback invokes the elasticsearch.CloseHttps API asynchronously
func (client *Client) CloseHttpsWithCallback(request *CloseHttpsRequest, callback func(response *CloseHttpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseHttpsResponse
		var err error
		defer close(result)
		response, err = client.CloseHttps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseHttpsRequest is the request struct for api CloseHttps
type CloseHttpsRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// CloseHttpsResponse is the response struct for api CloseHttps
type CloseHttpsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCloseHttpsRequest creates a request to invoke CloseHttps API
func CreateCloseHttpsRequest() (request *CloseHttpsRequest) {
	request = &CloseHttpsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CloseHttps", "/openapi/instances/[InstanceId]/actions/close-https", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseHttpsResponse creates a response to parse from CloseHttps response
func CreateCloseHttpsResponse() (response *CloseHttpsResponse) {
	response = &CloseHttpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
