package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateReadWritePolicy invokes the elasticsearch.UpdateReadWritePolicy API synchronously
func (client *Client) UpdateReadWritePolicy(request *UpdateReadWritePolicyRequest) (response *UpdateReadWritePolicyResponse, err error) {
	response = CreateUpdateReadWritePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateReadWritePolicyWithChan invokes the elasticsearch.UpdateReadWritePolicy API asynchronously
func (client *Client) UpdateReadWritePolicyWithChan(request *UpdateReadWritePolicyRequest) (<-chan *UpdateReadWritePolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateReadWritePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateReadWritePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateReadWritePolicyWithCallback invokes the elasticsearch.UpdateReadWritePolicy API asynchronously
func (client *Client) UpdateReadWritePolicyWithCallback(request *UpdateReadWritePolicyRequest, callback func(response *UpdateReadWritePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateReadWritePolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateReadWritePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateReadWritePolicyRequest is the request struct for api UpdateReadWritePolicy
type UpdateReadWritePolicyRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
}

// UpdateReadWritePolicyResponse is the response struct for api UpdateReadWritePolicy
type UpdateReadWritePolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdateReadWritePolicyRequest creates a request to invoke UpdateReadWritePolicy API
func CreateUpdateReadWritePolicyRequest() (request *UpdateReadWritePolicyRequest) {
	request = &UpdateReadWritePolicyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateReadWritePolicy", "/openapi/instances/[InstanceId]/actions/update-read-write-policy", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateReadWritePolicyResponse creates a response to parse from UpdateReadWritePolicy response
func CreateUpdateReadWritePolicyResponse() (response *UpdateReadWritePolicyResponse) {
	response = &UpdateReadWritePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
