package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFlowProjectUser invokes the emr.DeleteFlowProjectUser API synchronously
func (client *Client) DeleteFlowProjectUser(request *DeleteFlowProjectUserRequest) (response *DeleteFlowProjectUserResponse, err error) {
	response = CreateDeleteFlowProjectUserResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFlowProjectUserWithChan invokes the emr.DeleteFlowProjectUser API asynchronously
func (client *Client) DeleteFlowProjectUserWithChan(request *DeleteFlowProjectUserRequest) (<-chan *DeleteFlowProjectUserResponse, <-chan error) {
	responseChan := make(chan *DeleteFlowProjectUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFlowProjectUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFlowProjectUserWithCallback invokes the emr.DeleteFlowProjectUser API asynchronously
func (client *Client) DeleteFlowProjectUserWithCallback(request *DeleteFlowProjectUserRequest, callback func(response *DeleteFlowProjectUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFlowProjectUserResponse
		var err error
		defer close(result)
		response, err = client.DeleteFlowProjectUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFlowProjectUserRequest is the request struct for api DeleteFlowProjectUser
type DeleteFlowProjectUserRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Query" name:"ProjectId"`
	UserName  string `position:"Query" name:"UserName"`
}

// DeleteFlowProjectUserResponse is the response struct for api DeleteFlowProjectUser
type DeleteFlowProjectUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteFlowProjectUserRequest creates a request to invoke DeleteFlowProjectUser API
func CreateDeleteFlowProjectUserRequest() (request *DeleteFlowProjectUserRequest) {
	request = &DeleteFlowProjectUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteFlowProjectUser", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFlowProjectUserResponse creates a response to parse from DeleteFlowProjectUser response
func CreateDeleteFlowProjectUserResponse() (response *DeleteFlowProjectUserResponse) {
	response = &DeleteFlowProjectUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
