package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEcsImage invokes the faas.DeleteEcsImage API synchronously
// api document: https://help.aliyun.com/api/faas/deleteecsimage.html
func (client *Client) DeleteEcsImage(request *DeleteEcsImageRequest) (response *DeleteEcsImageResponse, err error) {
	response = CreateDeleteEcsImageResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEcsImageWithChan invokes the faas.DeleteEcsImage API asynchronously
// api document: https://help.aliyun.com/api/faas/deleteecsimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEcsImageWithChan(request *DeleteEcsImageRequest) (<-chan *DeleteEcsImageResponse, <-chan error) {
	responseChan := make(chan *DeleteEcsImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEcsImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEcsImageWithCallback invokes the faas.DeleteEcsImage API asynchronously
// api document: https://help.aliyun.com/api/faas/deleteecsimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEcsImageWithCallback(request *DeleteEcsImageRequest, callback func(response *DeleteEcsImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEcsImageResponse
		var err error
		defer close(result)
		response, err = client.DeleteEcsImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEcsImageRequest is the request struct for api DeleteEcsImage
type DeleteEcsImageRequest struct {
	*requests.RpcRequest
	ImageId string `position:"Query" name:"ImageId"`
}

// DeleteEcsImageResponse is the response struct for api DeleteEcsImage
type DeleteEcsImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ImageId   string `json:"ImageId" xml:"ImageId"`
}

// CreateDeleteEcsImageRequest creates a request to invoke DeleteEcsImage API
func CreateDeleteEcsImageRequest() (request *DeleteEcsImageRequest) {
	request = &DeleteEcsImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2020-02-17", "DeleteEcsImage", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEcsImageResponse creates a response to parse from DeleteEcsImage response
func CreateDeleteEcsImageResponse() (response *DeleteEcsImageResponse) {
	response = &DeleteEcsImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
