package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenRealPersonVerificationToken invokes the facebody.GenRealPersonVerificationToken API synchronously
func (client *Client) GenRealPersonVerificationToken(request *GenRealPersonVerificationTokenRequest) (response *GenRealPersonVerificationTokenResponse, err error) {
	response = CreateGenRealPersonVerificationTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GenRealPersonVerificationTokenWithChan invokes the facebody.GenRealPersonVerificationToken API asynchronously
func (client *Client) GenRealPersonVerificationTokenWithChan(request *GenRealPersonVerificationTokenRequest) (<-chan *GenRealPersonVerificationTokenResponse, <-chan error) {
	responseChan := make(chan *GenRealPersonVerificationTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenRealPersonVerificationToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenRealPersonVerificationTokenWithCallback invokes the facebody.GenRealPersonVerificationToken API asynchronously
func (client *Client) GenRealPersonVerificationTokenWithCallback(request *GenRealPersonVerificationTokenRequest, callback func(response *GenRealPersonVerificationTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenRealPersonVerificationTokenResponse
		var err error
		defer close(result)
		response, err = client.GenRealPersonVerificationToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenRealPersonVerificationTokenRequest is the request struct for api GenRealPersonVerificationToken
type GenRealPersonVerificationTokenRequest struct {
	*requests.RpcRequest
	MetaInfo          string `position:"Body" name:"MetaInfo"`
	CertificateNumber string `position:"Body" name:"CertificateNumber"`
	CertificateName   string `position:"Body" name:"CertificateName"`
}

// GenRealPersonVerificationTokenResponse is the response struct for api GenRealPersonVerificationToken
type GenRealPersonVerificationTokenResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGenRealPersonVerificationTokenRequest creates a request to invoke GenRealPersonVerificationToken API
func CreateGenRealPersonVerificationTokenRequest() (request *GenRealPersonVerificationTokenRequest) {
	request = &GenRealPersonVerificationTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "GenRealPersonVerificationToken", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenRealPersonVerificationTokenResponse creates a response to parse from GenRealPersonVerificationToken response
func CreateGenRealPersonVerificationTokenResponse() (response *GenRealPersonVerificationTokenResponse) {
	response = &GenRealPersonVerificationTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
