package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePackage invokes the foas.DeletePackage API synchronously
func (client *Client) DeletePackage(request *DeletePackageRequest) (response *DeletePackageResponse, err error) {
	response = CreateDeletePackageResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePackageWithChan invokes the foas.DeletePackage API asynchronously
func (client *Client) DeletePackageWithChan(request *DeletePackageRequest) (<-chan *DeletePackageResponse, <-chan error) {
	responseChan := make(chan *DeletePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePackageWithCallback invokes the foas.DeletePackage API asynchronously
func (client *Client) DeletePackageWithCallback(request *DeletePackageRequest, callback func(response *DeletePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePackageResponse
		var err error
		defer close(result)
		response, err = client.DeletePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePackageRequest is the request struct for api DeletePackage
type DeletePackageRequest struct {
	*requests.RoaRequest
	ProjectName string `position:"Path" name:"projectName"`
	PackageName string `position:"Path" name:"packageName"`
}

// DeletePackageResponse is the response struct for api DeletePackage
type DeletePackageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePackageRequest creates a request to invoke DeletePackage API
func CreateDeletePackageRequest() (request *DeletePackageRequest) {
	request = &DeletePackageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "DeletePackage", "/api/v2/projects/[projectName]/packages/[packageName]", "foas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeletePackageResponse creates a response to parse from DeletePackage response
func CreateDeletePackageResponse() (response *DeletePackageResponse) {
	response = &DeletePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
