package geoip

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpv6Location invokes the geoip.DescribeIpv6Location API synchronously
func (client *Client) DescribeIpv6Location(request *DescribeIpv6LocationRequest) (response *DescribeIpv6LocationResponse, err error) {
	response = CreateDescribeIpv6LocationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpv6LocationWithChan invokes the geoip.DescribeIpv6Location API asynchronously
func (client *Client) DescribeIpv6LocationWithChan(request *DescribeIpv6LocationRequest) (<-chan *DescribeIpv6LocationResponse, <-chan error) {
	responseChan := make(chan *DescribeIpv6LocationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpv6Location(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpv6LocationWithCallback invokes the geoip.DescribeIpv6Location API asynchronously
func (client *Client) DescribeIpv6LocationWithCallback(request *DescribeIpv6LocationRequest, callback func(response *DescribeIpv6LocationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpv6LocationResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpv6Location(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpv6LocationRequest is the request struct for api DescribeIpv6Location
type DescribeIpv6LocationRequest struct {
	*requests.RpcRequest
	Ip           string `position:"Query" name:"Ip"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeIpv6LocationResponse is the response struct for api DescribeIpv6Location
type DescribeIpv6LocationResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Ip          string `json:"Ip" xml:"Ip"`
	Country     string `json:"Country" xml:"Country"`
	Province    string `json:"Province" xml:"Province"`
	City        string `json:"City" xml:"City"`
	County      string `json:"County" xml:"County"`
	Isp         string `json:"Isp" xml:"Isp"`
	CountryCode string `json:"CountryCode" xml:"CountryCode"`
	CountryEn   string `json:"CountryEn" xml:"CountryEn"`
	ProvinceEn  string `json:"ProvinceEn" xml:"ProvinceEn"`
	CityEn      string `json:"CityEn" xml:"CityEn"`
	Longitude   string `json:"Longitude" xml:"Longitude"`
	Latitude    string `json:"Latitude" xml:"Latitude"`
}

// CreateDescribeIpv6LocationRequest creates a request to invoke DescribeIpv6Location API
func CreateDescribeIpv6LocationRequest() (request *DescribeIpv6LocationRequest) {
	request = &DescribeIpv6LocationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("geoip", "2020-01-01", "DescribeIpv6Location", "geoip", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpv6LocationResponse creates a response to parse from DescribeIpv6Location response
func CreateDescribeIpv6LocationResponse() (response *DescribeIpv6LocationResponse) {
	response = &DescribeIpv6LocationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
