package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLLogs invokes the gpdb.DescribeSQLLogs API synchronously
func (client *Client) DescribeSQLLogs(request *DescribeSQLLogsRequest) (response *DescribeSQLLogsResponse, err error) {
	response = CreateDescribeSQLLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLLogsWithChan invokes the gpdb.DescribeSQLLogs API asynchronously
func (client *Client) DescribeSQLLogsWithChan(request *DescribeSQLLogsRequest) (<-chan *DescribeSQLLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLLogsWithCallback invokes the gpdb.DescribeSQLLogs API asynchronously
func (client *Client) DescribeSQLLogsWithCallback(request *DescribeSQLLogsRequest, callback func(response *DescribeSQLLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLLogsRequest is the request struct for api DescribeSQLLogs
type DescribeSQLLogsRequest struct {
	*requests.RpcRequest
	StartTime      string           `position:"Query" name:"StartTime"`
	QueryKeywords  string           `position:"Query" name:"QueryKeywords"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	Database       string           `position:"Query" name:"Database"`
	SourceIP       string           `position:"Query" name:"SourceIP"`
	MinExecuteCost string           `position:"Query" name:"MinExecuteCost"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId   string           `position:"Query" name:"DBInstanceId"`
	MaxExecuteCost string           `position:"Query" name:"MaxExecuteCost"`
	ExecuteCost    string           `position:"Query" name:"ExecuteCost"`
	ExecuteState   string           `position:"Query" name:"ExecuteState"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OperationType  string           `position:"Query" name:"OperationType"`
	OperationClass string           `position:"Query" name:"OperationClass"`
	User           string           `position:"Query" name:"User"`
}

// DescribeSQLLogsResponse is the response struct for api DescribeSQLLogs
type DescribeSQLLogsResponse struct {
	*responses.BaseResponse
	PageRecordCount int    `json:"PageRecordCount" xml:"PageRecordCount"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	PageNumber      int    `json:"PageNumber" xml:"PageNumber"`
	Items           []Item `json:"Items" xml:"Items"`
}

// CreateDescribeSQLLogsRequest creates a request to invoke DescribeSQLLogs API
func CreateDescribeSQLLogsRequest() (request *DescribeSQLLogsRequest) {
	request = &DescribeSQLLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeSQLLogs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLLogsResponse creates a response to parse from DescribeSQLLogs response
func CreateDescribeSQLLogsResponse() (response *DescribeSQLLogsResponse) {
	response = &DescribeSQLLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
