/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.api.GradleException;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.util.internal.GUtil;

public class JavadocExecHandleBuilder {
    private final ExecActionFactory execActionFactory;
    private File execDirectory;
    private MinimalJavadocOptions options;
    private File optionsFile;
    private String executable;

    public JavadocExecHandleBuilder(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    public JavadocExecHandleBuilder execDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("execDirectory == null!");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("execDirectory doesn't exists!");
        }
        if (directory.isFile()) {
            throw new IllegalArgumentException("execDirectory is a file");
        }
        this.execDirectory = directory;
        return this;
    }

    public JavadocExecHandleBuilder options(MinimalJavadocOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("options == null!");
        }
        this.options = options;
        return this;
    }

    public JavadocExecHandleBuilder optionsFile(File optionsFile) {
        this.optionsFile = optionsFile;
        return this;
    }

    public ExecAction getExecHandle() {
        try {
            this.options.write(this.optionsFile);
        }
        catch (IOException e) {
            throw new GradleException("Failed to store javadoc options.", (Throwable)e);
        }
        ExecAction execAction = this.execActionFactory.newExecAction();
        execAction.workingDir((Object)this.execDirectory);
        execAction.executable(GUtil.getOrDefault((Object)this.executable, () -> Jvm.current().getJavadocExecutable()));
        execAction.args(new Object[]{"@" + this.optionsFile.getAbsolutePath()});
        this.options.contributeCommandLineOptions((ExecSpec)execAction);
        return execAction;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }
}

