/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.work.DisableCachingByDefault;

@NonNullApi
@DisableCachingByDefault(because="Super-class, not to be instantiated directly")
public abstract class SourceTask
extends ConventionTask
implements PatternFilterable {
    private ConfigurableFileCollection sourceFiles = this.getProject().getObjects().fileCollection();
    private final PatternFilterable patternSet = (PatternFilterable)this.getPatternSetFactory().create();

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    protected PatternFilterable getPatternSet() {
        return this.patternSet;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return this.sourceFiles.getAsFileTree().matching(this.patternSet);
    }

    public void setSource(FileTree source) {
        this.setSource((Object)source);
    }

    public void setSource(Object source) {
        this.sourceFiles = this.getProject().getObjects().fileCollection().from(new Object[]{source});
    }

    public SourceTask source(Object ... sources) {
        this.sourceFiles.from(sources);
        return this;
    }

    public SourceTask include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public SourceTask include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public SourceTask include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public SourceTask include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public SourceTask exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public SourceTask exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public SourceTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public SourceTask exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public SourceTask setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public SourceTask setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }
}

