/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.api.problems.internal.DefaultProblemsSummaryProgressDetails;
import org.gradle.api.problems.internal.ProblemLookup;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractOperationResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFailureResult;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultRootOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.launcher.exec.RunBuildBuildOperationType;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.provider.runner.ProblemsProgressEventUtils;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
class ClientForwardingBuildOperationListener
implements BuildOperationListener {
    protected final ProgressEventConsumer eventConsumer;
    private final boolean problemsRequested;
    private final boolean genericRequested;
    private final boolean rootRequested;
    private final Supplier<OperationIdentifier> operationIdentifierSupplier;

    ClientForwardingBuildOperationListener(ProgressEventConsumer eventConsumer, BuildEventSubscriptions buildEventSubscriptions, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        this.eventConsumer = eventConsumer;
        this.problemsRequested = buildEventSubscriptions.isRequested(OperationType.PROBLEMS);
        this.genericRequested = buildEventSubscriptions.isRequested(OperationType.GENERIC);
        this.rootRequested = buildEventSubscriptions.isRequested(OperationType.ROOT);
        this.operationIdentifierSupplier = operationIdentifierSupplier;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (this.rootRequested && buildOperation.getDetails() instanceof RunBuildBuildOperationType.Details || this.genericRequested) {
            this.eventConsumer.started((InternalOperationStartedProgressEvent)new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), this.toBuildOperationDescriptor(buildOperation)));
        }
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        if (this.problemsRequested) {
            Object details = progressEvent.getDetails();
            if (details instanceof DefaultProblemProgressDetails) {
                this.eventConsumer.progress((InternalProgressEvent)ProblemsProgressEventUtils.createProblemEvent(this.eventConsumer.findStartedParentId(buildOperationId), (DefaultProblemProgressDetails)details, this.operationIdentifierSupplier));
            } else if (details instanceof DefaultProblemsSummaryProgressDetails) {
                this.eventConsumer.progress((InternalProgressEvent)ProblemsProgressEventUtils.createProblemSummaryEvent(this.eventConsumer.findStartedParentId(buildOperationId), (DefaultProblemsSummaryProgressDetails)details, this.operationIdentifierSupplier));
            }
        }
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent result) {
        if (this.rootRequested && buildOperation.getDetails() instanceof RunBuildBuildOperationType.Details) {
            ProblemLookup problemLookup = ((RunBuildBuildOperationType.Details)buildOperation.getDetails()).getProblemLookup();
            this.eventConsumer.finished((InternalOperationFinishedProgressEvent)new DefaultOperationFinishedProgressEvent(result.getEndTime(), (DefaultOperationDescriptor)this.createRootOperationDescriptor(buildOperation), ClientForwardingBuildOperationListener.toOperationResult(result, problemLookup)));
        } else if (this.genericRequested) {
            this.eventConsumer.finished((InternalOperationFinishedProgressEvent)new DefaultOperationFinishedProgressEvent(result.getEndTime(), this.toBuildOperationDescriptor(buildOperation), ClientForwardingBuildOperationListener.toOperationResult(result)));
        }
    }

    public DefaultRootOperationDescriptor createRootOperationDescriptor(BuildOperationDescriptor buildOperation) {
        OperationIdentifier id = buildOperation.getId();
        String name = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        return new DefaultRootOperationDescriptor(id, name, displayName, null);
    }

    protected DefaultOperationDescriptor toBuildOperationDescriptor(BuildOperationDescriptor buildOperation) {
        OperationIdentifier id = buildOperation.getId();
        String name = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        OperationIdentifier parentId = this.eventConsumer.findStartedParentId(buildOperation);
        return new DefaultOperationDescriptor(id, name, displayName, parentId);
    }

    static AbstractOperationResult toOperationResult(OperationFinishEvent result) {
        return ClientForwardingBuildOperationListener.toOperationResult(result, null);
    }

    static AbstractOperationResult toOperationResult(OperationFinishEvent result, @Nullable ProblemLookup problemLookup) {
        Throwable failure = result.getFailure();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (failure != null) {
            if (problemLookup != null) {
                InternalFailure rootFailure = DefaultFailure.fromThrowable((Throwable)failure, (ProblemLookup)problemLookup, ProblemsProgressEventUtils::createDefaultProblemDetails);
                return new DefaultFailureResult(startTime, endTime, Collections.singletonList(rootFailure));
            }
            return new DefaultFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)));
        }
        return new DefaultSuccessResult(startTime, endTime);
    }
}

