/* A Bison parser, made by GNU Bison 3.5.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 12 "src/parser/parser.ypp"

#include <cstdint>
#include <cstdlib>
#include <iostream>
#include <vector>

#include "utils.hpp"
#include "parser/ast.hpp"
#include "proofs/dichotomy.hpp"
#include "parser/parser.hpp"

#define yyerror(msg) my_yyerror(yylloc, msg)

int yylex(YYSTYPE *yylval_param, YYLTYPE *yylloc_param);

#define error(msg) \
  std::cerr << "Error: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'
#define warning(msg) \
  std::cerr << "Warning: " << msg << " at line " << yylloc.first_line << " column " << yylloc.first_column << '\n'

int my_yyerror(YYLTYPE &yylloc, char const *errstr) {
    error(errstr);
    return EXIT_FAILURE;
}

#define failure(msg) do {\
  error(msg); \
  YYERROR; \
} while (0)

extern void register_user_rewrite(ast_real const *, ast_real const *, hint_cond_vect *);
extern void generate_all_approx();
extern void generate_graph(ast_prop const *p);
extern void parse_property_tree(property_tree &tree, ast_prop const *p);
extern void test_ringularity(ast_real const *, ast_real const *, bool);
extern int test_rewriting(ast_real const *, ast_real const *, std::string &);
extern void check_approx(ast_real const *);
extern std::set< ast_real const * > free_variables;
extern bool parameter_rfma;

static ast_number const *negative_number(ast_number const *nn) {
  if (nn->base == 0) return nn;
  ast_number n = *nn;
  char &c = n.mantissa[0];
  assert(c == '+');
  c = '-';
  return normalize(n);
}

static function_class const *rounding_mode = NULL;

static ast_real const *rnd_normalize(ast_real const &real) {
  ast_real const *r = normalize(real, true);
  if (!rounding_mode) return r;
  return normalize(ast_real(real_op(rounding_mode, r)), true);
}

static uintptr_t read_integer_param(ast_number const *n)
{
  return (static_cast<uintptr_t>(atoi(n->mantissa.c_str())) * 2) | 1;
}

static std::vector<function_generator *> user_functions;

RUN_LAST(free_generators) {
  for (std::vector<function_generator *>::const_iterator i = user_functions.begin(),
       i_end = user_functions.end(); i != i_end; ++i)
  {
    delete *i;
  }
  user_functions.clear();
}

#define YYINCLUDED_STDLIB_H


#line 147 "src/parser/parser.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED
# define YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    IN = 258,
    SQRT = 259,
    FMA = 260,
    NE = 261,
    LE = 262,
    GE = 263,
    RDIV = 264,
    FIX = 265,
    FLT = 266,
    NUMBER = 267,
    IDENT = 268,
    VARID = 269,
    FUNID = 270,
    IMPL = 271,
    OR = 272,
    AND = 273,
    NOT = 274,
    NEG = 275
  };
#endif
/* Tokens.  */
#define IN 258
#define SQRT 259
#define FMA 260
#define NE 261
#define LE 262
#define GE 263
#define RDIV 264
#define FIX 265
#define FLT 266
#define NUMBER 267
#define IDENT 268
#define VARID 269
#define FUNID 270
#define IMPL 271
#define OR 272
#define AND 273
#define NOT 274
#define NEG 275

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 95 "src/parser/parser.ypp"

  ast_number const	*number;
  ast_ident		*ident;
  ast_real const	*real;
  ast_real_vect		*reals;
  dichotomy_var		dvar;
  dvar_vect		*dvars;
  ast_prop		*prop;
  function_class const	*function;
  function_params	*params;
  uintptr_t		param;
  hint_cond		*precond;
  hint_cond_vect	*preconds;

#line 254 "src/parser/parser.cpp"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int yyparse (void);

#endif /* !YY_YY_SRC_PARSER_PARSER_HPP_INCLUDED  */



#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   386

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  41
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  24
/* YYNRULES -- Number of rules.  */
#define YYNRULES  83
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  192

#define YYUNDEFTOK  2
#define YYMAXUTOK   275


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    39,     2,     2,     2,
      27,    29,    23,    20,    28,    21,     2,    24,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    35,
      36,    34,    37,    32,    38,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    30,     2,    31,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    25,    33,    26,    40,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    22
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   140,   140,   141,   144,   149,   151,   153,   155,   156,
     157,   159,   161,   162,   163,   169,   170,   171,   172,   173,
     175,   175,   177,   177,   180,   181,   182,   185,   192,   199,
     200,   203,   204,   212,   213,   216,   229,   230,   237,   238,
     249,   257,   258,   259,   260,   263,   264,   265,   266,   275,
     286,   287,   288,   289,   290,   291,   292,   299,   300,   301,
     304,   305,   312,   313,   316,   317,   318,   321,   322,   329,
     330,   331,   332,   333,   336,   337,   344,   345,   347,   348,
     368,   384,   391,   403
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IN", "SQRT", "FMA", "NE", "LE", "GE",
  "RDIV", "FIX", "FLT", "NUMBER", "IDENT", "VARID", "FUNID", "IMPL", "OR",
  "AND", "NOT", "'+'", "'-'", "NEG", "'*'", "'/'", "'{'", "'}'", "'('",
  "','", "')'", "'['", "']'", "'?'", "'|'", "'='", "';'", "'<'", "'>'",
  "'@'", "'$'", "'~'", "$accept", "BLOB", "BLOB1", "PROP", "INTSEP",
  "MINUS", "SNUMBER", "INTEGER", "SINTEGER", "FUNCTION_PARAM",
  "FUNCTION_PARAMS_AUX", "FUNCTION_PARAMS", "FUNCTION", "EQUAL", "PROG",
  "REAL", "REALS", "DPOINTS", "DVAR", "DVARS", "PRECOND", "PRECONDS_AUX",
  "PRECONDS", "HINTS", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      43,    45,   275,    42,    47,   123,   125,    40,    44,    41,
      91,    93,    63,   124,    61,    59,    60,    62,    64,    36,
     126
};
# endif

#define YYPACT_NINF (-90)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -90,     1,   -90,    -1,   -90,   175,    10,   -90,   -90,   223,
      59,    26,    32,    37,    50,   -90,   -90,   -90,    14,   223,
     247,   247,    11,   223,   247,   247,   -13,    66,   144,   -18,
     -90,    88,   247,   110,   109,   101,   -90,   -90,   247,   247,
     247,   247,   149,   -90,   -90,   247,   247,    64,    64,   -90,
     128,   197,   189,   153,   -90,    -6,   223,   223,   223,   247,
     247,    79,   247,    27,    27,   247,   247,   247,   -90,   -90,
     247,   247,   247,   247,   247,   247,   247,   -90,   261,   -90,
     133,   290,   320,   329,   338,   -90,   -90,   142,   143,   -90,
     -90,   -90,   -20,   300,   271,   -90,   -90,   247,   -90,    31,
     247,   -90,   165,   141,   -90,    17,   362,    68,    27,   -90,
     362,   -90,   -90,   255,   356,    64,   -90,   -90,   362,   266,
      64,   362,    28,   -90,   157,   -90,   247,    27,   151,   -90,
     -90,   149,   -90,   285,   -90,    27,   -90,   -90,   -90,   -90,
      73,   161,   247,   172,   -90,   -90,   -90,   347,   186,   187,
     -90,   216,   -90,    85,   -90,   -90,    27,    27,   -90,    83,
     -90,   173,   -90,   247,   -90,   -90,   212,    27,   -90,   194,
      73,    27,    27,    27,    27,    27,   -90,   247,   310,   -90,
     -90,   -90,    27,   -90,   -90,   -90,   -90,   -90,   -90,   -90,
     198,   -90
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      38,     0,    78,     0,     1,     2,     0,    41,    42,     0,
       0,     0,     0,     0,     0,    46,    48,    47,    33,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    60,     0,
      36,     0,     0,     0,     0,     0,    43,    44,     0,     0,
       0,     0,     0,    35,    18,     0,     0,    58,    59,    45,
       0,     0,     0,    64,    67,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    22,    23,
       0,     0,     0,     0,     0,     0,     0,    37,     0,     3,
       0,     0,     0,     0,     0,    24,    30,     0,     0,    28,
      29,    31,     0,     0,     0,    19,    57,     0,    54,     0,
       0,    82,    17,    16,    15,     0,    60,     0,     0,     8,
      14,     4,     9,     0,    76,    50,    52,    53,    13,     0,
      51,    61,     0,    39,     0,    55,     0,     0,     0,    25,
      26,     0,    34,     0,    27,     0,    65,    68,    81,    49,
       0,     0,     0,     0,    83,    80,    40,     0,     0,     0,
      32,     0,    62,     0,    20,    21,     0,     0,    12,     0,
      74,     0,    79,     0,     5,     6,     0,     0,    66,     0,
       0,     0,     0,     0,     0,     0,    77,     0,     0,    11,
      63,     7,     0,    69,    70,    71,    72,    73,    75,    56,
       0,    10
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -90,   -90,   -90,    23,    60,   -33,   -57,   104,   -89,   108,
     -90,   -90,    -4,   -90,   -90,    -5,   180,   -90,   146,   -48,
      70,   -90,   -90,   -90
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,    26,   156,    74,    89,   136,    90,    91,
      92,    43,    27,    32,     3,    34,    29,   153,    54,    55,
     160,   161,   143,     5
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      28,     4,    31,    56,    57,    58,   111,   112,   131,    88,
      75,   105,     6,     7,     8,    47,    48,   132,    51,    52,
      53,    76,   100,    49,     9,    18,    59,    78,   122,   101,
      88,    88,    33,    81,    82,    83,    84,    10,   148,    85,
      93,    94,    44,   134,    30,   100,    50,    87,    68,    69,
      42,   140,   138,    38,    53,   106,   100,   110,   135,    39,
     113,   114,   115,   145,    40,   116,   117,   118,   119,   120,
     121,    53,    35,    36,    37,    88,   124,    41,   152,   102,
     103,   104,   183,   184,   185,   186,   187,    70,    71,   171,
     172,   173,   133,    60,    88,    53,    75,   139,    88,   169,
     170,   154,    88,    67,    68,    69,    70,    71,   155,   108,
     180,   109,    61,   167,   168,    62,    63,    64,    65,   174,
     175,   147,    77,    88,    88,   190,    56,    57,    58,    67,
      68,    69,    70,    71,    88,    80,    79,   159,    88,    88,
      88,    88,    88,    72,    56,    57,    58,    61,    18,    88,
      62,    63,    64,    65,   129,   130,    99,    95,   178,    58,
      66,    85,    86,   134,    67,    68,    69,    70,    71,    87,
      68,    69,   159,    67,    68,    69,    70,    71,    72,    11,
      12,    56,    57,    58,    73,    13,    14,    15,    16,    17,
      18,   157,   146,   158,    19,    20,    21,    22,    97,   176,
      61,   177,    23,    62,    63,    64,    65,   162,    24,    67,
      68,    69,    70,    71,    25,   164,   165,    67,    68,    69,
      70,    71,    98,   166,   179,   181,    96,    11,    12,   191,
     182,    72,   149,    13,    14,    15,    16,    17,    18,   150,
     107,     0,    19,    20,    21,    22,   137,   188,     0,     0,
      23,    11,    12,     0,     0,     0,    24,     0,   141,    15,
      16,    17,    18,     0,     0,     0,     0,    20,    21,    22,
       0,     0,     0,     0,    45,    67,    68,    69,    70,    71,
      46,    67,    68,    69,    70,    71,    67,    68,    69,    70,
      71,    67,    68,    69,    70,    71,   123,     0,     0,     0,
       0,   144,     0,     0,    98,    67,    68,    69,    70,    71,
      67,    68,    69,    70,    71,     0,     0,     0,   151,   125,
      67,    68,    69,    70,    71,     0,     0,     0,     0,    96,
      67,    68,    69,    70,    71,     0,     0,     0,     0,   189,
      67,    68,    69,    70,    71,     0,     0,     0,   126,    67,
      68,    69,    70,    71,     0,     0,     0,   127,    67,    68,
      69,    70,    71,     0,     0,     0,   128,    67,    68,    69,
      70,    71,     0,     0,     0,   163,    67,    68,    69,    70,
      71,   142,    67,    68,    69,    70,    71
};

static const yytype_int16 yycheck[] =
{
       5,     0,     6,    16,    17,    18,    63,    64,    28,    42,
      28,    59,    13,    14,    15,    20,    21,    37,    23,    24,
      25,    39,    28,    12,    25,    15,    39,    32,    76,    35,
      63,    64,     9,    38,    39,    40,    41,    38,   127,    12,
      45,    46,    19,    12,    34,    28,    23,    20,    21,    22,
      36,   108,    35,    27,    59,    60,    28,    62,    27,    27,
      65,    66,    67,    35,    27,    70,    71,    72,    73,    74,
      75,    76,    13,    14,    15,   108,    80,    27,   135,    56,
      57,    58,   171,   172,   173,   174,   175,    23,    24,     6,
       7,     8,    97,    27,   127,   100,    28,    29,   131,   156,
     157,    28,   135,    20,    21,    22,    23,    24,    35,    30,
     167,    32,     3,    28,    29,     6,     7,     8,     9,    36,
      37,   126,    34,   156,   157,   182,    16,    17,    18,    20,
      21,    22,    23,    24,   167,    34,    26,   142,   171,   172,
     173,   174,   175,    34,    16,    17,    18,     3,    15,   182,
       6,     7,     8,     9,    12,    12,     3,    29,   163,    18,
      16,    12,    13,    12,    20,    21,    22,    23,    24,    20,
      21,    22,   177,    20,    21,    22,    23,    24,    34,     4,
       5,    16,    17,    18,    40,    10,    11,    12,    13,    14,
      15,    30,    35,    32,    19,    20,    21,    22,     9,    26,
       3,    28,    27,     6,     7,     8,     9,    35,    33,    20,
      21,    22,    23,    24,    39,    29,    29,    20,    21,    22,
      23,    24,    33,     7,    12,    31,    29,     4,     5,    31,
     170,    34,   128,    10,    11,    12,    13,    14,    15,   131,
      60,    -1,    19,    20,    21,    22,   100,   177,    -1,    -1,
      27,     4,     5,    -1,    -1,    -1,    33,    -1,     3,    12,
      13,    14,    15,    -1,    -1,    -1,    -1,    20,    21,    22,
      -1,    -1,    -1,    -1,    27,    20,    21,    22,    23,    24,
      33,    20,    21,    22,    23,    24,    20,    21,    22,    23,
      24,    20,    21,    22,    23,    24,    35,    -1,    -1,    -1,
      -1,    35,    -1,    -1,    33,    20,    21,    22,    23,    24,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    33,    29,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    29,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    29,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    28,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    28,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    28,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    28,    20,    21,    22,    23,
      24,    25,    20,    21,    22,    23,    24
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    42,    43,    55,     0,    64,    13,    14,    15,    25,
      38,     4,     5,    10,    11,    12,    13,    14,    15,    19,
      20,    21,    22,    27,    33,    39,    44,    53,    56,    57,
      34,    53,    54,    44,    56,    13,    14,    15,    27,    27,
      27,    27,    36,    52,    44,    27,    33,    56,    56,    12,
      44,    56,    56,    56,    59,    60,    16,    17,    18,    39,
      27,     3,     6,     7,     8,     9,    16,    20,    21,    22,
      23,    24,    34,    40,    46,    28,    39,    34,    56,    26,
      34,    56,    56,    56,    56,    12,    13,    20,    46,    47,
      49,    50,    51,    56,    56,    29,    29,     9,    33,     3,
      28,    35,    44,    44,    44,    60,    56,    57,    30,    32,
      56,    47,    47,    56,    56,    56,    56,    56,    56,    56,
      56,    56,    60,    35,    53,    29,    28,    28,    28,    12,
      12,    28,    37,    56,    12,    27,    48,    59,    35,    29,
      47,     3,    25,    63,    35,    35,    35,    56,    49,    48,
      50,    33,    47,    58,    28,    35,    45,    30,    32,    56,
      61,    62,    35,    28,    29,    29,     7,    28,    29,    47,
      47,     6,     7,     8,    36,    37,    26,    28,    56,    12,
      47,    31,    45,    49,    49,    49,    49,    49,    61,    29,
      47,    31
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int8 yyr1[] =
{
       0,    41,    42,    43,    44,    44,    44,    44,    44,    44,
      44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
      45,    45,    46,    46,    47,    47,    47,    48,    49,    50,
      50,    51,    51,    52,    52,    53,    54,    54,    55,    55,
      55,    55,    55,    55,    55,    56,    56,    56,    56,    56,
      56,    56,    56,    56,    56,    56,    56,    56,    56,    56,
      57,    57,    58,    58,    59,    59,    59,    60,    60,    61,
      61,    61,    61,    61,    62,    62,    63,    63,    64,    64,
      64,    64,    64,    64
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     4,     3,     6,     6,     7,     3,     3,
       9,     7,     5,     3,     3,     3,     3,     3,     2,     3,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     3,     0,     3,     2,     1,     2,     0,     5,
       6,     2,     2,     3,     3,     2,     1,     1,     1,     4,
       3,     3,     3,     3,     3,     4,     8,     3,     2,     2,
       1,     3,     1,     3,     1,     3,     5,     1,     3,     3,
       3,     3,     3,     3,     1,     3,     0,     3,     0,     6,
       5,     5,     4,     5
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yytype, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[+yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[+*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2:
#line 140 "src/parser/parser.ypp"
                                { generate_all_approx(); }
#line 1707 "src/parser/parser.cpp"
    break;

  case 3:
#line 141 "src/parser/parser.ypp"
                                { generate_graph((yyvsp[-1].prop)); generate_all_approx(); }
#line 1713 "src/parser/parser.cpp"
    break;

  case 4:
#line 145 "src/parser/parser.ypp"
  {
    real_op const *p = boost::get< real_op const >((yyvsp[-2].real));
    (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (!p || p->type != UOP_ABS) ? NULL : token_zero, (yyvsp[0].number)));
  }
#line 1722 "src/parser/parser.cpp"
    break;

  case 5:
#line 150 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_fix((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1728 "src/parser/parser.cpp"
    break;

  case 6:
#line 152 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_flt((yyvsp[-3].real), atoi((yyvsp[-1].number)->mantissa.c_str()))); }
#line 1734 "src/parser/parser.cpp"
    break;

  case 7:
#line 154 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1740 "src/parser/parser.cpp"
    break;

  case 8:
#line 155 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), NULL, NULL)); }
#line 1746 "src/parser/parser.cpp"
    break;

  case 9:
#line 156 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_bnd((yyvsp[-2].real), (yyvsp[0].number), NULL)); }
#line 1752 "src/parser/parser.cpp"
    break;

  case 10:
#line 158 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-8].real), (yyvsp[-6].real), (yyvsp[-3].number), (yyvsp[-1].number))); }
#line 1758 "src/parser/parser.cpp"
    break;

  case 11:
#line 160 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-5].real), (yyvsp[-3].real), negative_number((yyvsp[0].number)), (yyvsp[0].number))); }
#line 1764 "src/parser/parser.cpp"
    break;

  case 12:
#line 161 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_rel((yyvsp[-4].real), (yyvsp[-2].real), NULL, NULL)); }
#line 1770 "src/parser/parser.cpp"
    break;

  case 13:
#line 162 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))); }
#line 1776 "src/parser/parser.cpp"
    break;

  case 14:
#line 164 "src/parser/parser.ypp"
  {
    ast_number const *const *r = boost::get<ast_number const *const>((yyvsp[0].real));
    if (r && *r == token_zero) (yyval.prop) = new ast_prop(ast_atom_nzr((yyvsp[-2].real)));
    else (yyval.prop) = new ast_prop(new ast_prop(ast_atom_eql((yyvsp[-2].real), (yyvsp[0].real))));
  }
#line 1786 "src/parser/parser.cpp"
    break;

  case 15:
#line 169 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_AND,  (yyvsp[0].prop)); }
#line 1792 "src/parser/parser.cpp"
    break;

  case 16:
#line 170 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_OR,   (yyvsp[0].prop)); }
#line 1798 "src/parser/parser.cpp"
    break;

  case 17:
#line 171 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[-2].prop), PROP_IMPL, (yyvsp[0].prop)); }
#line 1804 "src/parser/parser.cpp"
    break;

  case 18:
#line 172 "src/parser/parser.ypp"
                        { (yyval.prop) = new ast_prop((yyvsp[0].prop)); }
#line 1810 "src/parser/parser.cpp"
    break;

  case 19:
#line 173 "src/parser/parser.ypp"
                        { (yyval.prop) = (yyvsp[-1].prop); }
#line 1816 "src/parser/parser.cpp"
    break;

  case 24:
#line 180 "src/parser/parser.ypp"
                { (yyval.number) = (yyvsp[0].number); }
#line 1822 "src/parser/parser.cpp"
    break;

  case 25:
#line 181 "src/parser/parser.ypp"
                { (yyval.number) = (yyvsp[0].number); }
#line 1828 "src/parser/parser.cpp"
    break;

  case 26:
#line 182 "src/parser/parser.ypp"
                { (yyval.number) = negative_number((yyvsp[0].number)); }
#line 1834 "src/parser/parser.cpp"
    break;

  case 27:
#line 186 "src/parser/parser.ypp"
  {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1843 "src/parser/parser.cpp"
    break;

  case 28:
#line 193 "src/parser/parser.ypp"
  {
    if ((yyvsp[0].number)->exponent != 0 || (yyvsp[0].number)->mantissa.size() >= 7) failure("integer expected");
    (yyval.number) = (yyvsp[0].number);
  }
#line 1852 "src/parser/parser.cpp"
    break;

  case 29:
#line 199 "src/parser/parser.ypp"
                { (yyval.param) = read_integer_param((yyvsp[0].number)); }
#line 1858 "src/parser/parser.cpp"
    break;

  case 30:
#line 200 "src/parser/parser.ypp"
                { (yyval.param) = reinterpret_cast<uintptr_t>((yyvsp[0].ident)); }
#line 1864 "src/parser/parser.cpp"
    break;

  case 31:
#line 203 "src/parser/parser.ypp"
                        { (yyval.params) = new function_params(1, (yyvsp[0].param)); }
#line 1870 "src/parser/parser.cpp"
    break;

  case 32:
#line 205 "src/parser/parser.ypp"
  {
    function_params *p = (yyvsp[-2].params);
    p->push_back((yyvsp[0].param));
    (yyval.params) = p;
  }
#line 1880 "src/parser/parser.cpp"
    break;

  case 33:
#line 212 "src/parser/parser.ypp"
                                { (yyval.params) = NULL; }
#line 1886 "src/parser/parser.cpp"
    break;

  case 34:
#line 213 "src/parser/parser.ypp"
                                { (yyval.params) = (yyvsp[-1].params); }
#line 1892 "src/parser/parser.cpp"
    break;

  case 35:
#line 217 "src/parser/parser.ypp"
  {
    ast_ident *r = (yyvsp[-1].ident);
    function_class const *f;
    if (function_params *p = (yyvsp[0].params)) {
      f = (*r->fun)(*p);
      delete p;
    } else f = (*r->fun)(function_params());
    if (!f) failure("invalid parameters for '" << r->name << "'");
    (yyval.function) = f;
  }
#line 1907 "src/parser/parser.cpp"
    break;

  case 37:
#line 231 "src/parser/parser.ypp"
  {
    function_class const *f = (yyvsp[-1].function);
    if (f->type != UOP_ID) failure("rounding operator expected, got '" << f->pretty_name() << "'");
    rounding_mode = f;
  }
#line 1917 "src/parser/parser.cpp"
    break;

  case 39:
#line 239 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[-3].ident);
    ast_real const *r = (yyvsp[-1].real);
    if (v->type != ID_NONE) failure("redefinition of identifier '" << (yyvsp[-3].ident)->name << "'");
    v->type = ID_VAR;
    v->var = r;
    if (r->name) warning("renaming identifier '" << r->name->name << "' as '" << v->name << "'");
    r->name = v;
    rounding_mode = NULL;
  }
#line 1932 "src/parser/parser.cpp"
    break;

  case 40:
#line 250 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[-3].ident);
    v->type = ID_FUN;
    function_generator *g = new default_function_generator((yyvsp[-1].function));
    v->fun = g;
    user_functions.push_back(g);
  }
#line 1944 "src/parser/parser.cpp"
    break;

  case 41:
#line 257 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1950 "src/parser/parser.cpp"
    break;

  case 42:
#line 258 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1956 "src/parser/parser.cpp"
    break;

  case 43:
#line 259 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1962 "src/parser/parser.cpp"
    break;

  case 44:
#line 260 "src/parser/parser.ypp"
                        { failure("redefinition of identifier '" << (yyvsp[0].ident)->name << "'"); }
#line 1968 "src/parser/parser.cpp"
    break;

  case 45:
#line 263 "src/parser/parser.ypp"
                { (yyval.real) = normalize(negative_number((yyvsp[0].number)), true); }
#line 1974 "src/parser/parser.cpp"
    break;

  case 46:
#line 264 "src/parser/parser.ypp"
                { (yyval.real) = normalize(ast_real((yyvsp[0].number)), true); }
#line 1980 "src/parser/parser.cpp"
    break;

  case 47:
#line 265 "src/parser/parser.ypp"
                { (yyval.real) = (yyvsp[0].ident)->var; }
#line 1986 "src/parser/parser.cpp"
    break;

  case 48:
#line 267 "src/parser/parser.ypp"
  {
    ast_ident *v = (yyvsp[0].ident);
    v->type = ID_VAR;
    ast_real *r = normalize(ast_real(v), true);
    free_variables.insert(r);
    v->var = r;
    (yyval.real) = r;
  }
#line 1999 "src/parser/parser.cpp"
    break;

  case 49:
#line 276 "src/parser/parser.ypp"
  {
    function_class const *f = (yyvsp[-3].function);
    ast_real_vect *ops = (yyvsp[-1].reals);
    if ((f->type == UOP_ID && ops->size() != 1) ||
        (f->type != UOP_ID && f->type != COP_FMA && ops->size() != 2) ||
        (f->type == COP_FMA && ops->size() != 3))
      failure("incorrect number of arguments for '" << f->pretty_name() << "'");
    (yyval.real) = normalize(ast_real(real_op(f, *ops)), true);
    delete ops;
  }
#line 2014 "src/parser/parser.cpp"
    break;

  case 50:
#line 286 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_ADD, (yyvsp[0].real)))); }
#line 2020 "src/parser/parser.cpp"
    break;

  case 51:
#line 287 "src/parser/parser.ypp"
                                { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_SUB, (yyvsp[0].real)))); }
#line 2026 "src/parser/parser.cpp"
    break;

  case 52:
#line 288 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_MUL, (yyvsp[0].real)))); }
#line 2032 "src/parser/parser.cpp"
    break;

  case 53:
#line 289 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-2].real), BOP_DIV, (yyvsp[0].real)))); }
#line 2038 "src/parser/parser.cpp"
    break;

  case 54:
#line 290 "src/parser/parser.ypp"
                        { (yyval.real) = normalize(ast_real(real_op(UOP_ABS, (yyvsp[-1].real))), true); }
#line 2044 "src/parser/parser.cpp"
    break;

  case 55:
#line 291 "src/parser/parser.ypp"
                        { (yyval.real) = rnd_normalize(ast_real(real_op(UOP_SQRT, (yyvsp[-1].real)))); }
#line 2050 "src/parser/parser.cpp"
    break;

  case 56:
#line 293 "src/parser/parser.ypp"
  {
    if (!parameter_rfma)
      (yyval.real) = rnd_normalize(ast_real(real_op(normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true), BOP_ADD, (yyvsp[-1].real))));
    else
      (yyval.real) = rnd_normalize(ast_real(real_op((yyvsp[-1].real), BOP_ADD, normalize(ast_real(real_op((yyvsp[-5].real), BOP_MUL, (yyvsp[-3].real))), true))));
  }
#line 2061 "src/parser/parser.cpp"
    break;

  case 57:
#line 299 "src/parser/parser.ypp"
                        { (yyval.real) = (yyvsp[-1].real); }
#line 2067 "src/parser/parser.cpp"
    break;

  case 58:
#line 300 "src/parser/parser.ypp"
                        { (yyval.real) = (yyvsp[0].real); }
#line 2073 "src/parser/parser.cpp"
    break;

  case 59:
#line 301 "src/parser/parser.ypp"
                        { (yyval.real) = normalize(ast_real(real_op(UOP_NEG, (yyvsp[0].real))), true); }
#line 2079 "src/parser/parser.cpp"
    break;

  case 60:
#line 304 "src/parser/parser.ypp"
                { (yyval.reals) = new ast_real_vect(1, (yyvsp[0].real)); }
#line 2085 "src/parser/parser.cpp"
    break;

  case 61:
#line 306 "src/parser/parser.ypp"
  {
    (yyvsp[-2].reals)->push_back((yyvsp[0].real));
    (yyval.reals) = (yyvsp[-2].reals);
  }
#line 2094 "src/parser/parser.cpp"
    break;

  case 62:
#line 312 "src/parser/parser.ypp"
                        { (yyval.param) = fill_splitter(0, (yyvsp[0].number)); }
#line 2100 "src/parser/parser.cpp"
    break;

  case 63:
#line 313 "src/parser/parser.ypp"
                        { (yyval.param) = fill_splitter((yyvsp[-2].param), (yyvsp[0].number)); }
#line 2106 "src/parser/parser.cpp"
    break;

  case 64:
#line 316 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[0].real), 0 }; (yyval.dvar) = v; }
#line 2112 "src/parser/parser.cpp"
    break;

  case 65:
#line 317 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[-2].real), read_integer_param((yyvsp[0].number)) }; (yyval.dvar) = v; }
#line 2118 "src/parser/parser.cpp"
    break;

  case 66:
#line 318 "src/parser/parser.ypp"
                                { dichotomy_var v = { (yyvsp[-4].real), (yyvsp[-1].param) }; (yyval.dvar) = v; }
#line 2124 "src/parser/parser.cpp"
    break;

  case 67:
#line 321 "src/parser/parser.ypp"
                { (yyval.dvars) = new dvar_vect(1, (yyvsp[0].dvar)); }
#line 2130 "src/parser/parser.cpp"
    break;

  case 68:
#line 323 "src/parser/parser.ypp"
  {
    (yyvsp[-2].dvars)->push_back((yyvsp[0].dvar));
    (yyval.dvars) = (yyvsp[-2].dvars);
  }
#line 2139 "src/parser/parser.cpp"
    break;

  case 69:
#line 329 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_NE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2145 "src/parser/parser.cpp"
    break;

  case 70:
#line 330 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_LE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2151 "src/parser/parser.cpp"
    break;

  case 71:
#line 331 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_GE, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2157 "src/parser/parser.cpp"
    break;

  case 72:
#line 332 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_LT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2163 "src/parser/parser.cpp"
    break;

  case 73:
#line 333 "src/parser/parser.ypp"
                        { (yyval.precond) = new hint_cond(COND_GT, (yyvsp[-2].real), (yyvsp[0].number)); }
#line 2169 "src/parser/parser.cpp"
    break;

  case 74:
#line 336 "src/parser/parser.ypp"
          { (yyval.preconds) = new hint_cond_vect(1, (yyvsp[0].precond)); }
#line 2175 "src/parser/parser.cpp"
    break;

  case 75:
#line 338 "src/parser/parser.ypp"
  {
    (yyvsp[-2].preconds)->push_back((yyvsp[0].precond));
    (yyval.preconds) = (yyvsp[-2].preconds);
  }
#line 2184 "src/parser/parser.cpp"
    break;

  case 76:
#line 344 "src/parser/parser.ypp"
                        { (yyval.preconds) = NULL; }
#line 2190 "src/parser/parser.cpp"
    break;

  case 77:
#line 345 "src/parser/parser.ypp"
                        { (yyval.preconds) = (yyvsp[-1].preconds); }
#line 2196 "src/parser/parser.cpp"
    break;

  case 79:
#line 349 "src/parser/parser.ypp"
  {
    ast_real const *r1 = (yyvsp[-4].real), *r2 = (yyvsp[-2].real);
    hint_cond_vect *hc = (yyvsp[-1].preconds);
    test_ringularity(r1, r2, !hc);
    std::string info;
    int t = test_rewriting(r1, r2, info);
    if (t == 1) {
      warning("no need for the rewriting");
      std::cerr << "  if one of the following relations is present\n" << info;
    } else if (t == 2) {
      warning("no need for the rewriting");
      if (!info.empty())
        std::cerr << "  if all the following properties can be proved\n" << info;
    }
    check_approx(r1);
    register_user_rewrite(r1, r2, hc);
    register_approx(r1, r2);
    delete hc;
  }
#line 2220 "src/parser/parser.cpp"
    break;

  case 80:
#line 369 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    ast_prop *p = NULL;
    for (ast_real_vect::const_iterator i = (yyvsp[-3].reals)->begin(), i_end = (yyvsp[-3].reals)->end();
         i != i_end; ++i)
    {
      ast_prop *q = new ast_prop(ast_atom_bnd(*i, NULL, NULL));
      if (!p) p = q;
      else p = new ast_prop(p, PROP_AND, q);
    }
    delete (yyvsp[-3].reals);
    parse_property_tree(h.dst, p);
    dichotomies.push_back(h);
  }
#line 2240 "src/parser/parser.cpp"
    break;

  case 81:
#line 385 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    parse_property_tree(h.dst, (yyvsp[-3].prop));
    dichotomies.push_back(h);
  }
#line 2251 "src/parser/parser.cpp"
    break;

  case 82:
#line 392 "src/parser/parser.ypp"
  {
    dichotomy_hint h = { *(yyvsp[-1].dvars), property_tree(), true };
    delete (yyvsp[-1].dvars);
    for (dvar_vect::iterator i = h.src.begin(),
         i_end = h.src.end(); i != i_end; ++i)
    {
      // no target property and no splitter, make it four-part by default
      if (!i->splitter) i->splitter = 9;
    }
    dichotomies.push_back(h);
  }
#line 2267 "src/parser/parser.cpp"
    break;

  case 83:
#line 404 "src/parser/parser.ypp"
  {
    if (!register_approx((yyvsp[-3].real), (yyvsp[-1].real)))
      warning("relation already known");
  }
#line 2276 "src/parser/parser.cpp"
    break;


#line 2280 "src/parser/parser.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[+*yyssp], yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
