/*
    SPDX-FileCopyrightText: 2009, 2010, 2012 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_STRUCTUREDEFINITIONFILE_HPP
#define KASTEN_STRUCTUREDEFINITIONFILE_HPP

// tool
#include "structuremetadata.hpp"
#include <enumdefinition.hpp>
// Qt
#include <QString>
#include <QDir>
#include <QStringList>
#include <QDomNodeList>
#include <QFileInfo>
// Std
#include <memory>
#include <vector>

class TopLevelDataInformation;
class AbstractStructureParser;

namespace Kasten {

/**
 *  This class takes care of all the XML parsing and stores the result.
 */
class StructureDefinitionFile
{
public:
    enum class Location {
        ToplevelDir,
        SubDir,
    };

public:
    /**
     * This class uses lazy parsing
     * @param info the information about this structure definition
     *      (passed by value so nothing bad can happen)
     */
    explicit StructureDefinitionFile(const StructureMetaData& metaData, Location location);
    StructureDefinitionFile(const StructureDefinitionFile&) = delete;
    StructureDefinitionFile(StructureDefinitionFile&&) = delete;

    ~StructureDefinitionFile();

    StructureDefinitionFile& operator=(const StructureDefinitionFile&) = delete;
    StructureDefinitionFile& operator=(StructureDefinitionFile&&) = delete;

public:
    [[nodiscard]]
    std::vector<std::unique_ptr<TopLevelDataInformation>> structures() const;
    [[nodiscard]]
    QStringList structureNames() const;
    [[nodiscard]]
    std::unique_ptr<TopLevelDataInformation> structure(const QString& name) const;
    [[nodiscard]]
    StructureMetaData metaData() const;
    [[nodiscard]]
    bool isValid() const;
    [[nodiscard]]
    Location location() const;

private:
    const StructureMetaData mMetaData;
    const Location m_location;
    std::unique_ptr<AbstractStructureParser> mParser;
};

} // namespace Kasten

#endif /* KASTEN_STRUCTUREDEFINITIONFILE_HPP */
