/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import org.hampelratte.svdrp.parsers.ChannelLineParser;
import org.hampelratte.svdrp.parsers.DVBChannelLineParser;
import org.hampelratte.svdrp.parsers.GroupChannelLineParser;
import org.hampelratte.svdrp.parsers.PvrInputChannelLineParser;

public class ChannelLineParserFactory {
    private static DVBChannelLineParser dvb;
    private static PvrInputChannelLineParser pvr;
    private static GroupChannelLineParser group;

    public static ChannelLineParser createChannelParser(String chanConfLine) throws Exception {
        if (ChannelLineParserFactory.isDvbChannel(chanConfLine)) {
            if (dvb == null) {
                dvb = new DVBChannelLineParser();
            }
            return dvb;
        }
        if (ChannelLineParserFactory.isPvrInputChannel(chanConfLine)) {
            if (pvr == null) {
                pvr = new PvrInputChannelLineParser();
            }
            return pvr;
        }
        if (ChannelLineParserFactory.isGroup(chanConfLine)) {
            if (group == null) {
                group = new GroupChannelLineParser();
            }
            return group;
        }
        throw new Exception("Unknown format for channels.conf lines: " + chanConfLine);
    }

    private static boolean isGroup(String chanConfLine) {
        return chanConfLine.startsWith("0 :");
    }

    private static boolean isPvrInputChannel(String chanConfLine) {
        char first;
        int pos = -1;
        for (int i = 0; i < 3; ++i) {
            pos = chanConfLine.indexOf(58, pos + 1);
        }
        return ++pos >= 7 && ((first = chanConfLine.charAt(pos)) == 'V' || first == 'P');
    }

    private static boolean isDvbChannel(String chanConfLine) {
        char first;
        int pos = -1;
        for (int i = 0; i < 3; ++i) {
            pos = chanConfLine.indexOf(58, pos + 1);
        }
        return ++pos >= 7 && ((first = chanConfLine.charAt(pos)) == 'S' || first == 'C' || first == 'T');
    }
}

