/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hampelratte.svdrp.Connection;
import org.hampelratte.svdrp.Version;
import org.hampelratte.svdrp.responses.highlevel.Recording;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingListParser {
    private static transient Logger logger = LoggerFactory.getLogger(RecordingListParser.class);

    public static List<Recording> parse(String response) {
        ArrayList<Recording> list = new ArrayList<Recording>();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yy HH:mm");
        StringBuffer title = new StringBuffer();
        StringTokenizer st = new StringTokenizer(response, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            Recording recording = new Recording();
            StringTokenizer st2 = new StringTokenizer(line);
            int number = Integer.parseInt(st2.nextToken());
            recording.setNumber(number);
            String date = st2.nextToken() + " " + st2.nextToken();
            Version v = Connection.getVersion();
            Version v1_7_21 = new Version("1.7.21");
            if (v.compareTo(v1_7_21) < 0) {
                if (RecordingListParser.isNew(date)) {
                    date = date.substring(0, date.length() - 1);
                    recording.setNew(true);
                }
            } else {
                String duration = st2.nextToken();
                if (RecordingListParser.isNew(duration)) {
                    duration = duration.substring(0, duration.length() - 1);
                    recording.setNew(true);
                }
                String[] parts = duration.split(":");
                int hours = Integer.parseInt(parts[0]);
                int minutes = Integer.parseInt(parts[1]);
                recording.setDuration(hours * 60 + minutes);
            }
            try {
                recording.setStartTime(df.parse(date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            title.setLength(0);
            while (st2.hasMoreTokens()) {
                title.append(st2.nextToken());
                title.append(' ');
            }
            recording.setTitle(title.toString().trim());
            list.add(recording);
        }
        return list;
    }

    private static boolean isNew(String token) {
        char c = token.charAt(token.length() - 1);
        if (!Character.isDigit(c)) {
            if (c == '*' || c == '\ue010') {
                return true;
            }
            logger.warn("Last character [{}] is not a digit and not one of the \"new\" indicators '*' '\ue010'", (Object)Character.valueOf(c));
        }
        return false;
    }
}

