/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDateType
extends BaseDataType {
    protected static final DateStringFormatConfig defaultDateFormatConfig = new DateStringFormatConfig("yyyy-MM-dd HH:mm:ss.SSSSSS");

    protected BaseDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    protected static DateStringFormatConfig convertDateStringConfig(FieldType fieldType, DateStringFormatConfig defaultDateFormatConfig) {
        if (fieldType == null) {
            return defaultDateFormatConfig;
        }
        DateStringFormatConfig configObj = (DateStringFormatConfig)fieldType.getDataTypeConfigObj();
        if (configObj == null) {
            return defaultDateFormatConfig;
        }
        return configObj;
    }

    protected static Date parseDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        return dateFormat.parse(dateStr);
    }

    protected static String normalizeDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = formatConfig.getDateFormat();
        Date date = dateFormat.parse(dateStr);
        return dateFormat.format(date);
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        long newVal = System.currentTimeMillis();
        if (currentValue == null) {
            return new Date(newVal);
        }
        if (newVal == ((Date)currentValue).getTime()) {
            return new Date(newVal + 1L);
        }
        return new Date(newVal);
    }

    @Override
    public boolean isValidForField(Field field) {
        return field.getType() == Date.class;
    }

    protected static class DateStringFormatConfig {
        private final ThreadLocal<DateFormat> threadLocal = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat(DateStringFormatConfig.this.dateFormatStr);
            }
        };
        final String dateFormatStr;

        public DateStringFormatConfig(String dateFormatStr) {
            this.dateFormatStr = dateFormatStr;
        }

        public DateFormat getDateFormat() {
            return this.threadLocal.get();
        }

        public String toString() {
            return this.dateFormatStr;
        }
    }
}

