/*
  gmorgan - a ryhthm station software

  gmorgan.MIDIImport.C  -  MIDI Import functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modified by Josep Andreu

*/


#include "GMorgan.h"
#include <iostream>

int 
GMO::ImportaMidi()
{
// Open Midi File 
  char *filename;
  FILE *fs;
  int Nutrak, MNtracks, MTiempoBase,MFormato;    
  int TrackLen, dato, nota, velo;
  int TTdelta = 0;
  int Tdelta = 0;
  int posicion = 1;
  int tipo, canal, longi;
  filename = MidiImportFilename;
  cout << " Open Midi File " << filename << endl;
  cMidiRead = 0;
  int MPonNotaD = 8000;
  int MPonNotaB = 8000;

  if (MiDrumsMCh > 0) MPonNotaD = 143 + MiDrumsMCh;
  if (MiBassMCh > 0) MPonNotaB = 143 + MiBassMCh;  
  cout << " MiBassMCh " << MiBassMCh << endl;
  if ((fs = fopen (filename, "rb")) != NULL)
   {
// Check if is Midi File
  if (MAGIC_FILE != leer_bytes(fs, 4))
     { 
       fclose(fs);
       return(1); 
     }
  if ( leer_bytes(fs,4) != 6)
      {
       fclose(fs);
       return(1);
     }

// Check if is Midi File type 1
 MFormato= leer_bytes(fs,2);
if (MFormato != 1)
      {
       fclose(fs);
       return(2);
     }
MNtracks = leer_bytes(fs,2);
MTiempoBase = leer_bytes(fs,2);
    
// Search track importable
for (Nutrak = 1; Nutrak <= MNtracks; Nutrak++)
{
cout << " Track ********** " << Nutrak << endl;

//Read track Header
 if (MAGIC_TRACK != leer_bytes(fs, 4))  printf("Track Header ?\n");
TrackLen = leer_bytes(fs,4);

// import data
tipo= 0;
canal = 0;
cMidiRead = 0;
longi = 0;
posicion = 1; 
TTdelta = 0;
Tdelta = 0;
LaUltima = 0;
while (cMidiRead < TrackLen)
         {
          Tdelta = leer_delta(fs);
          TTdelta += Tdelta;
          posicion = (int)( TTdelta / (MTiempoBase/4))+1;
          dato = leer_bytes(fs,1);
          if ((dato & 0x80) == 0 )
          { 
              ungetc(dato,fs);
              cMidiRead--;  
          }
          else
          {
          tipo = dato & 0xf0;
          canal = dato & 0x0f;
          }
          switch(tipo)
           {
            case MIDI_CMD_NOTE_ON:
              		nota = leer_bytes(fs,1);
          		velo = leer_bytes(fs,1);
                        PonerDatoMidi(canal, nota, velo, posicion);
                        break;
            case MIDI_CMD_NOTE_OFF:
                        nota = leer_bytes(fs,1);
                        velo = leer_bytes(fs,1);
                        PonerDatoMidi(canal, nota, velo, posicion);
                        break;
                 
            case MIDI_CMD_NOTE_PRESSURE:
                        nota = leer_bytes(fs,1);
                        velo = leer_bytes(fs,1);
                        PonerDatoMidi(canal, nota, velo, posicion);
                        break;
            case MIDI_CMD_CONTROL:
                        nota = leer_bytes(fs,1);
                        velo = leer_bytes(fs,1);
                        PonerControlMidi(canal,nota,velo);
                        break;

            case MIDI_CMD_PGM_CHANGE:
                        nota = leer_bytes(fs,1);
                        PonerProgramMidi(canal,nota);
                        break;

            case MIDI_CMD_CHANNEL_PRESSURE:
                        nota = leer_bytes(fs,1);
                        break;
           
            case MIDI_CMD_BENDER:
                        nota = leer_bytes(fs,1);
                        velo = leer_bytes(fs,1);
                        break;
            
            case MIDI_CMD_COMMON_SYSEX:
                        nota = leer_bytes(fs,1);
                        velo = leer_delta(fs);
                        nota = leer_bytes(fs,velo);
                        break;
            }
}
}
fclose(fs);
Rt[sp].bars = MiBars;
Rt[sp].blackn =MiNominator;
PonTempDrum(sp);
return(0);
}
else return(1);
};

int 
GMO::leer_bytes(FILE *fp, int n)
{
        int  valor;
        int  i;
        int  lectura;

        valor = 0;
        for (i = 0; i < n; i++) {
                valor <<= 8;
                lectura = getc(fp);
                cMidiRead++;
                if (lectura == -1) 
                     {
			cout << " Unexpected end of file " << endl;		     	
                      //printf (gettext("Unexpected end of file\n"));
                      
                     }
                valor |= lectura;
        }

        return valor;
};

unsigned long
GMO::leer_delta (FILE *fp)
{

        unsigned long valor;
        int c;

        if ((valor = getc(fp)) & 0x80) {
                valor &= 0x7f;
                do  {
                        valor = (valor << 7) + ((c = getc(fp)) & 0x7f);
                        cMidiRead++;
                }  while (c & 0x80);
                
        }
        cMidiRead++;
        return valor;
};


void

GMO::PonerDatoMidi(int Pista, int Nota, int Velo, int Mposic)
{
cout << " PonerDatoMidi " << Pista+1 << " Note " << Nota << " Velo " << Velo << " Mposic " << Mposic << endl;
int i,j;
int PonerNota = 0;
Mposic = Mposic - ((MiStart -1)  * 4 * MiNominator);
if ((Mposic > 0) && Mposic <= (MiBars * 4 * MiNominator))
{
if ((Pista +1) == MiDrumsMCh)
{
     if (Velo != 0) Edr[Nota-26][Mposic] = Velo;
     return;
}

if ((Pista+1) == MiBassMCh)
{
if (Mmodebass==1)
{
 if (Nota >= LaUltima)
  PonerNota = (Nota % 12) + 1 - MiBaseKey;
  else
  PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
  LaUltima = Nota;
}

if (Mmodebass==2)
{
    if (Nota < (36 + MiBaseKey))
    PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
    else
    {
    PonerNota = (Nota % 12) + 1 - MiBaseKey;
    if (Nota >= 48 ) PonerNota += 12;
    }
}
    if (Velo != 0) 
        {
        Rt[sp].basn[0][Mposic] = PonerNota;
        Rt[sp].basn[1][Mposic] = Velo;
        return;
        }

    if (Velo == 0)
        for (i = Mposic; i>=1; i--)
          {
           if ((Rt[sp].basn[0][i] == PonerNota) || (Rt[sp].basn[0][i] == (PonerNota-14)))
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].basn[2][i] = (int) (16/j);
                   break;           
                 } 
          }
          return;
}

if ((Pista+1) == MiAcc3MCh)
{
LaUltima = (int)(Nota / 12); 
if (LaUltima >= 5)
  PonerNota = (Nota % 12) + 1 - MiBaseKey + ((LaUltima - 5) * 12);
  else
  PonerNota = (Nota % 12) + 1 - MiBaseKey - ((5 - LaUltima) * 12) ;
if (PonerNota < 40) PonerNota += 12;
 if (Velo != 0)
        {
       if( Rt[sp].acc3n[0][Mposic] != 0)
       {
       if( Rt[sp].acc3n[0][Mposic] < PonerNota) Rt[sp].acc3n[0][Mposic] = PonerNota ;
       }
       else Rt[sp].acc3n[0][Mposic] = PonerNota ;
        Rt[sp].acc3n[1][Mposic] = Velo;
        return;
        }

 if (Velo == 0)
        for (i = Mposic; i>=1; i--)
          {
           if ((Rt[sp].acc3n[0][i] == PonerNota) || (Rt[sp].acc3n[0][i] == (PonerNota-14)))
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].acc3n[2][i] = (int) (16/j);
                   break;
                 }
          }
          return;
}

if ((Pista+1) == MiAcc5MCh)
{
LaUltima = (int)(Nota / 12); 
if (LaUltima >= 5)
  PonerNota = (Nota % 12) + 1 - MiBaseKey + ((LaUltima - 5) * 12);
  else
  PonerNota = (Nota % 12) + 1 - MiBaseKey - ((5 - LaUltima) * 12) ;
  if (PonerNota < 40) PonerNota += 12;

 if (Velo != 0)
        {
       if( Rt[sp].acc5n[0][Mposic] != 0)
       {
       if( Rt[sp].acc5n[0][Mposic] < PonerNota) Rt[sp].acc5n[0][Mposic] = PonerNota ;
       }
       else Rt[sp].acc5n[0][Mposic] = PonerNota ;
        Rt[sp].acc5n[1][Mposic] = Velo;
        return;
        }

 if (Velo == 0)
        for (i = Mposic; i>=1; i--)
          {
           if ((Rt[sp].acc5n[0][i] == PonerNota) || (Rt[sp].acc5n[0][i] == (PonerNota-14)))
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].acc5n[2][i] = (int) (16/j);
                   break;
                 }
          }
          return;
}

if ((Pista+1) == MiAcc2MCh)
{
if (Mmodeacc2==1)
{
 if (Nota >= LaUltima)
  PonerNota = (Nota % 12) + 1 - MiBaseKey;
  else
  PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
  LaUltima = Nota;
}

if (Mmodeacc2==2)
{
    if (Nota < (48 + MiBaseKey))
    PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
    else
    {
    PonerNota = (Nota % 12) + 1 - MiBaseKey;
    if (Nota >= 60) PonerNota += 12;
    }
}

 if (Velo != 0)
        {
        PonerNota = PonerNota -12;     
        Rt[sp].acc2n[0][Mposic] = PonerNota ;
        Rt[sp].acc2n[1][Mposic] = Velo;
        return;
        }

 if (Velo == 0)
        PonerNota = PonerNota -12;
        for (i = Mposic; i>=1; i--)
          {
           if ((Rt[sp].acc2n[0][i] == PonerNota) || (Rt[sp].acc2n[0][i] == (PonerNota-14)))
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].acc2n[2][i] = (int) (16/j);
                   break;
                 }
          }
          return;
}

if ((Pista+1) == MiAcc4MCh)
{
if (Mmodeacc4==1)
{
 if (Nota >= LaUltima)
  PonerNota = (Nota % 12) + 1 - MiBaseKey;
  else
  PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
  LaUltima = Nota;
}

if (Mmodeacc4==2)
{
    if (Nota < (48 + MiBaseKey))
    PonerNota = (Nota % 12) + 1 - MiBaseKey - 14;
    else
    {
    PonerNota = (Nota % 12) + 1 - MiBaseKey;
    if (Nota >= 60) PonerNota += 12;
    }
}

 if (Velo != 0)
        {
        PonerNota = PonerNota -12;     
        Rt[sp].acc4n[0][Mposic] = PonerNota ;
        Rt[sp].acc4n[1][Mposic] = Velo;
        return;
        }

 if (Velo == 0)
        PonerNota = PonerNota -12;
        for (i = Mposic; i>=1; i--)
          {
           if ((Rt[sp].acc4n[0][i] == PonerNota) || (Rt[sp].acc4n[0][i] == (PonerNota-14)))
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].acc4n[2][i] = (int) (16/j);
                   break;
                 }
          }
          return;
}

if ((Pista+1) == MiAcc1MCh)
{
 if (Velo != 0)
        {
        Rt[sp].acc1n[1][Mposic] = Velo;
        return;
        }

 if (Velo == 0)
        for (i = Mposic; i>=1; i--)
          {
           if (Rt[sp].acc1n[1][i] != 0)
                 {
                   j = Mposic -i;
                   if (j==0) j=1;
                   Rt[sp].acc1n[0][i] = (int) (16/j);
                   break;
                 }
          }
          return;
}
}
};

void 
GMO::PonerControlMidi(int Pista, int Control, int Valor)
{
cout << " ControlMidi Channel = " << Pista+1 << " Control " << Control << " Value " << Valor << endl;
if ((Pista+1) == MiAcc1MCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].acc1vol = Valor;
               break;
           case 10:
               Rt[sp].acc1pan = Valor;
               break;
           case 91:
               Rt[sp].acc1rev = Valor;
               break;
           case 93:
               Rt[sp].acc1cho = Valor;
               break;
          }
return;
}

if ((Pista+1) == MiAcc2MCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].acc2vol = Valor;
               break;
           case 10:
               Rt[sp].acc2pan = Valor;
               break;
           case 91:
               Rt[sp].acc2rev = Valor;
               break;
           case 93:
               Rt[sp].acc2cho = Valor;
               break;
          }
return;

}

if ((Pista+1) == MiAcc3MCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].acc3vol = Valor;
               break;
           case 10:
               Rt[sp].acc3pan = Valor;
               break;
           case 91:
               Rt[sp].acc3rev = Valor;
               break;
           case 93:
               Rt[sp].acc3cho = Valor;
               break;
          }
return;
}

if ((Pista+1) == MiAcc4MCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].acc4vol = Valor;
               break;
           case 10:
               Rt[sp].acc4pan = Valor;
               break;
           case 91:
               Rt[sp].acc4rev = Valor;
               break;
           case 93:
               Rt[sp].acc4cho = Valor;
               break;
          }
return;
}

if ((Pista+1) == MiAcc5MCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].acc5vol = Valor;
               break;
           case 10:
               Rt[sp].acc5pan = Valor;
               break;
           case 91:
               Rt[sp].acc5rev = Valor;
               break;
           case 93:
               Rt[sp].acc5cho = Valor;
               break;
          }
return;
}

if ((Pista+1) == MiBassMCh)
{
  cout << " Bass Channel " << MiBassMCh << " case " << Control << endl;
  switch(Control)
         {
           case 7:
               Rt[sp].bassvol = Valor;
               break;
           case 10:
               Rt[sp].basspan = Valor;
               break;
           case 91:
               Rt[sp].bassrev = Valor;
               break;
           case 93:
               Rt[sp].basscho = Valor;
               break;
          }
return;
}

if ((Pista+1) == MiDrumsMCh)
{
  switch(Control)
         {
           case 7:
               Rt[sp].drvol = Valor;
               break;
           case 10:
               Rt[sp].drpan = Valor;
               break;
           case 91:
               Rt[sp].drrev = Valor;
               break;
           case 93:
               Rt[sp].drcho = Valor;
               break;
          }
return;

}

};


void 
GMO::PonerProgramMidi(int Pista, int Programa)
{
cout << " Table Midi Channel " << Pista+1 << "data " << Programa << endl; 
if ((Pista+1) == MiAcc1MCh)
{
   Rt[sp].acc1pc = Programa;
   return;
}

if ((Pista+1) == MiAcc2MCh)
{
   Rt[sp].acc2pc = Programa;
   return;
}

if ((Pista+1) == MiAcc3MCh)
{
   Rt[sp].acc3pc = Programa;
   return;
}

if ((Pista+1) == MiAcc4MCh)
{
   Rt[sp].acc4pc = Programa;
   return;
}

if ((Pista+1) == MiAcc5MCh)
{
   Rt[sp].acc5pc = Programa;
   return;
}

if ((Pista+1) == MiBassMCh)
{
   Rt[sp].basspc = Programa;
   return;
}

if ((Pista+1) == MiDrumsMCh)
{
   Rt[sp].drpc = Programa;
   return;
}
};
