/* arch-tag: ca7e2882-6c14-431f-8274-c5cd0f6883d0 */

/*  eXperience GTK engine: drawable.h
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __DRAWABLE_H
#define __DRAWABLE_H

#include <gtk/gtk.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "data.h"
#include "filter.h"
#include "utils.h"
#include "render.h"

typedef struct _eXperienceDrawable eXperienceDrawable;
typedef struct _eXperienceDrawableClass eXperienceDrawableClass;

#include "group.h"

typedef struct {
	gfloat widget;
	gfloat object;
	gint   pixel;
} eXperiencePercent;


struct _eXperienceDrawableClass {
	gchar * object_type;
	
	eXperienceDrawable * (*create) (void);
	
	void (*inherit_from_drawable) (eXperienceDrawable * drawable, eXperienceDrawable * from);
	
	void (*apply_group_settings) (eXperienceDrawable * drawable, eXperienceGroup * group);
	
	void (*destroy) (eXperienceDrawable * drawable);
	
	gboolean (*draw_begin) (eXperienceDrawable * drawable, GtkStyle * style, gpointer * tmp_data, gint * width, gint * height, gboolean * fail);
	/* I don't know whether it tiling is needed when calling draw_begin. */
	gboolean (*draw) (eXperienceDrawable * drawable, gboolean may_tile, gpointer tmp_data, eXperienceRenderContext * dest, GdkRectangle * dest_area, GdkRectangle * clip_area);
	gboolean (*draw_end) (eXperienceDrawable * drawable, gpointer tmp_data);
};

typedef struct _eXperienceDrawablePrivate eXperienceDrawablePrivate;

struct _eXperienceDrawable {
	eXperienceDrawableClass * class;
	
	gint number;
	
	eXperienceFilter filter;
	
	gchar * group_name;
	
	eXperienceDrawablePrivate * private;
};

eXperienceDrawable * experience_drawable_create (eXperienceDrawableClass * class, gint number, gchar * group_name)  EXPERIENCE_INTERNAL;
eXperienceDrawable * experience_drawable_duplicate (eXperienceDrawable * drawable, gchar * group_name) EXPERIENCE_INTERNAL;

void experience_drawable_ref (eXperienceDrawable * drawable) EXPERIENCE_INTERNAL;
void experience_drawable_unref (eXperienceDrawable * drawable) EXPERIENCE_INTERNAL;

void experience_drawable_set_dont_inherit (eXperienceDrawable * drawable, gboolean dont_inherit) EXPERIENCE_INTERNAL;
void experience_drawable_set_dont_draw (eXperienceDrawable * drawable, gboolean dont_draw) EXPERIENCE_INTERNAL;
void experience_drawable_set_padding (eXperienceDrawable * drawable, gint left, gint right, gint top, gint bottom) EXPERIENCE_INTERNAL;

void experience_drawable_set_width (eXperienceDrawable * drawable, eXperiencePercent width) EXPERIENCE_INTERNAL;
void experience_drawable_set_height (eXperienceDrawable * drawable, eXperiencePercent height) EXPERIENCE_INTERNAL;
void experience_drawable_set_pos (eXperienceDrawable * drawable, eXperiencePercent pos, eXperienceOrientation orientation) EXPERIENCE_INTERNAL;

void experience_drawable_set_repeat (eXperienceDrawable * drawable, guint left, guint right, guint top, guint bottom) EXPERIENCE_INTERNAL;
void experience_drawable_set_inner_padding (eXperienceDrawable * drawable, guint left, guint right, guint top, guint bottom) EXPERIENCE_INTERNAL;
void experience_drawable_set_rounding (eXperienceDrawable * drawable, eXperienceRoundingMethod rounding) EXPERIENCE_INTERNAL;
void experience_drawable_set_draw_entire_only (eXperienceDrawable * drawable, gboolean draw_entire_only) EXPERIENCE_INTERNAL;
void experience_drawable_set_dont_clip (eXperienceDrawable * drawable, gboolean dont_clip) EXPERIENCE_INTERNAL;


void experience_drawable_apply_group_settings (eXperienceDrawable * drawable, eXperienceGroup * group) EXPERIENCE_INTERNAL;
void experience_drawable_inherit_from (eXperienceDrawable * drawable, eXperienceDrawable * from) EXPERIENCE_INTERNAL;
gboolean experience_drawable_draw (eXperienceDrawable * drawable, eXperienceRenderContext * dest, GdkRectangle * dest_area, GtkStyle * style) EXPERIENCE_INTERNAL;

#endif /* __DRAWABLE_H */
