/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.ArtifactType;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.DefaultArtifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.DefaultArtifactType;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.Exclusion;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.Proxy;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RepositoryPolicy;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.apache.maven.resolver.internal.ant.types.Authentication;
import org.apache.maven.resolver.internal.ant.types.Dependency;
import org.apache.maven.resolver.internal.ant.types.RemoteRepositories;
import org.apache.maven.resolver.internal.ant.types.RemoteRepository;
import org.apache.tools.ant.Project;

class ConverterUtils {
    ConverterUtils() {
    }

    private static Artifact toArtifact(Dependency dependency, ArtifactTypeRegistry types) {
        ArtifactType type = types.get(dependency.getType());
        if (type == null) {
            type = new DefaultArtifactType(dependency.getType());
        }
        Map<String, String> props = null;
        if ("system".equals(dependency.getScope()) && dependency.getSystemPath() != null) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath().getPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, type);
        return artifact;
    }

    public static org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.Authentication toAuthentication(Authentication auth) {
        if (auth == null) {
            return null;
        }
        AuthenticationBuilder authBuilder = new AuthenticationBuilder();
        authBuilder.addUsername(auth.getUsername()).addPassword(auth.getPassword());
        authBuilder.addPrivateKey(auth.getPrivateKeyFile(), auth.getPassphrase());
        return authBuilder.build();
    }

    public static org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.Dependency toDependency(Dependency dependency, List<org.apache.maven.resolver.internal.ant.types.Exclusion> exclusions, RepositorySystemSession session) {
        return new org.apache.maven.resolver.internal.ant.org.eclipse.aether.graph.Dependency(ConverterUtils.toArtifact(dependency, session.getArtifactTypeRegistry()), dependency.getScope(), false, ConverterUtils.toExclusions(dependency.getExclusions(), exclusions));
    }

    public static org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository toDistRepository(RemoteRepository repo, RepositorySystemSession session) {
        org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository result = ConverterUtils.toRepository(repo);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(result);
        builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(result));
        builder.setProxy(session.getProxySelector().getProxy(result));
        return builder.build();
    }

    private static Exclusion toExclusion(org.apache.maven.resolver.internal.ant.types.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), exclusion.getClassifier(), exclusion.getExtension());
    }

    private static Collection<Exclusion> toExclusions(Collection<org.apache.maven.resolver.internal.ant.types.Exclusion> exclusions1, Collection<org.apache.maven.resolver.internal.ant.types.Exclusion> exclusions2) {
        LinkedHashSet<Exclusion> results = new LinkedHashSet<Exclusion>();
        if (exclusions1 != null) {
            for (org.apache.maven.resolver.internal.ant.types.Exclusion exclusion : exclusions1) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        if (exclusions2 != null) {
            for (org.apache.maven.resolver.internal.ant.types.Exclusion exclusion : exclusions2) {
                results.add(ConverterUtils.toExclusion(exclusion));
            }
        }
        return results;
    }

    private static RepositoryPolicy toPolicy(RemoteRepository.Policy policy, boolean enabled, String updates, String checksums) {
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getChecksums() != null) {
                checksums = policy.getChecksums();
            }
            if (policy.getUpdates() != null) {
                updates = policy.getUpdates();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    public static Properties addProperties(Properties props, Map<?, ?> map) {
        if (props == null) {
            props = new Properties();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Proxy toProxy(org.apache.maven.resolver.internal.ant.types.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        return new Proxy(proxy.getType(), proxy.getHost(), proxy.getPort(), ConverterUtils.toAuthentication(proxy.getAuthentication()));
    }

    private static org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository toRepository(RemoteRepository repo) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getId(), repo.getType(), repo.getUrl());
        builder.setSnapshotPolicy(ConverterUtils.toPolicy(repo.getSnapshotPolicy(), repo.isSnapshots(), repo.getUpdates(), repo.getChecksums()));
        builder.setReleasePolicy(ConverterUtils.toPolicy(repo.getReleasePolicy(), repo.isReleases(), repo.getUpdates(), repo.getChecksums()));
        builder.setAuthentication(ConverterUtils.toAuthentication(repo.getAuthentication()));
        return builder.build();
    }

    public static List<org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository> toRepositories(Project project, RepositorySystemSession session, RemoteRepositories repos, RemoteRepositoryManager remoteRepositoryManager) {
        List<RemoteRepository> repositories = repos != null ? repos.getRepositories() : new ArrayList<RemoteRepository>();
        List<org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository> results = new ArrayList<org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository>();
        for (RemoteRepository repo : repositories) {
            results.add(ConverterUtils.toRepository(repo));
        }
        results = remoteRepositoryManager.aggregateRepositories(session, Collections.emptyList(), results, true);
        return results;
    }
}

