/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_3570298.core.data;

import java.io.IOException;
import java.io.InputStream;
import org.jacoco.agent.rt.internal_3570298.core.data.ExecutionData;
import org.jacoco.agent.rt.internal_3570298.core.data.ExecutionDataWriter;
import org.jacoco.agent.rt.internal_3570298.core.data.IExecutionDataVisitor;
import org.jacoco.agent.rt.internal_3570298.core.data.ISessionInfoVisitor;
import org.jacoco.agent.rt.internal_3570298.core.data.IncompatibleExecDataVersionException;
import org.jacoco.agent.rt.internal_3570298.core.data.SessionInfo;
import org.jacoco.agent.rt.internal_3570298.core.internal.data.CompactDataInput;

public class ExecutionDataReader {
    protected final CompactDataInput in;
    private ISessionInfoVisitor sessionInfoVisitor = null;
    private IExecutionDataVisitor executionDataVisitor = null;
    private boolean firstBlock = true;

    public ExecutionDataReader(InputStream input) {
        this.in = new CompactDataInput(input);
    }

    public void setSessionInfoVisitor(ISessionInfoVisitor visitor) {
        this.sessionInfoVisitor = visitor;
    }

    public void setExecutionDataVisitor(IExecutionDataVisitor visitor) {
        this.executionDataVisitor = visitor;
    }

    public boolean read() throws IOException, IncompatibleExecDataVersionException {
        byte type;
        do {
            int i;
            if ((i = this.in.read()) == -1) {
                return false;
            }
            type = (byte)i;
            if (this.firstBlock && type != 1) {
                throw new IOException("Invalid execution data file.");
            }
            this.firstBlock = false;
        } while (this.readBlock(type));
        return true;
    }

    protected boolean readBlock(byte blocktype) throws IOException {
        switch (blocktype) {
            case 1: {
                this.readHeader();
                return true;
            }
            case 16: {
                this.readSessionInfo();
                return true;
            }
            case 17: {
                this.readExecutionData();
                return true;
            }
        }
        throw new IOException(String.format("Unknown block type %x.", blocktype));
    }

    private void readHeader() throws IOException {
        if (this.in.readChar() != '\uc0c0') {
            throw new IOException("Invalid execution data file.");
        }
        char version = this.in.readChar();
        if (version != ExecutionDataWriter.FORMAT_VERSION) {
            throw new IncompatibleExecDataVersionException(version);
        }
    }

    private void readSessionInfo() throws IOException {
        if (this.sessionInfoVisitor == null) {
            throw new IOException("No session info visitor.");
        }
        String id = this.in.readUTF();
        long start = this.in.readLong();
        long dump = this.in.readLong();
        this.sessionInfoVisitor.visitSessionInfo(new SessionInfo(id, start, dump));
    }

    private void readExecutionData() throws IOException {
        if (this.executionDataVisitor == null) {
            throw new IOException("No execution data visitor.");
        }
        long id = this.in.readLong();
        String name = this.in.readUTF();
        boolean[] probes = this.in.readBooleanArray();
        this.executionDataVisitor.visitClassExecution(new ExecutionData(id, name, probes));
    }
}

