/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.batch.LogOutput;
import org.sonarsource.scanner.api.internal.cache.Logger;

public class SimulatedLauncher
implements IsolatedLauncher {
    private final String version;
    private final Logger logger;

    SimulatedLauncher(String version, Logger logger) {
        this.version = version;
        this.logger = logger;
    }

    @Override
    public void execute(Map<String, String> props, LogOutput logOutput) {
        String filePath = props.get("sonar.scanner.dumpToFile");
        SimulatedLauncher.writeProperties(filePath, props);
        this.logger.info("Simulation mode. Configuration written to " + new File(filePath).getAbsolutePath());
    }

    private static void writeProperties(String filePath, Map<String, String> p) {
        Properties props = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        props.putAll(p);
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            props.store(outputStream, "# Generated by a SonarQube Scanner");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to export scanner properties", e);
        }
    }

    static void writeProp(BufferedWriter output, Map.Entry<String, String> e) {
        try {
            output.write(e.getKey() + "=" + e.getValue());
            output.newLine();
        }
        catch (IOException e1) {
            throw new IllegalStateException("Fail to export scanner properties", e1);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

