/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentTypeDetector {
    public static final int UNKNOWN = -1;
    public static final int CLASSFILE = -889275714;
    public static final int ZIPFILE = 1347093252;
    public static final int GZFILE = 529203200;
    public static final int PACK200FILE = -889270259;
    private static final int BUFFER_SIZE = 8;
    private final InputStream in;
    private final int type;

    public ContentTypeDetector(InputStream in) throws IOException {
        this.in = in.markSupported() ? in : new BufferedInputStream(in, 8);
        this.in.mark(8);
        this.type = ContentTypeDetector.determineType(this.in);
        this.in.reset();
    }

    private static int determineType(InputStream in) throws IOException {
        int header = ContentTypeDetector.readInt(in);
        switch (header) {
            case 1347093252: {
                return 1347093252;
            }
            case -889270259: {
                return -889270259;
            }
            case -889275714: {
                int majorVersion = ContentTypeDetector.readInt(in) & 0xFFFF;
                if (majorVersion < 45) break;
                return -889275714;
            }
        }
        if ((header & 0xFFFF0000) == 529203200) {
            return 529203200;
        }
        return -1;
    }

    private static int readInt(InputStream in) throws IOException {
        return in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getType() {
        return this.type;
    }
}

