/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.core.internal.analysis.Instruction;
import org.jacoco.cli.internal.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCoverageCalculator
implements IFilterOutput {
    private final Map<AbstractInsnNode, Instruction> instructions;
    private final Set<AbstractInsnNode> ignored;
    private final Map<AbstractInsnNode, AbstractInsnNode> merged;
    private final Map<AbstractInsnNode, Set<AbstractInsnNode>> replacements;

    MethodCoverageCalculator(Map<AbstractInsnNode, Instruction> instructions) {
        this.instructions = instructions;
        this.ignored = new HashSet<AbstractInsnNode>();
        this.merged = new HashMap<AbstractInsnNode, AbstractInsnNode>();
        this.replacements = new HashMap<AbstractInsnNode, Set<AbstractInsnNode>>();
    }

    void calculate(MethodCoverageImpl coverage) {
        this.applyMerges();
        this.applyReplacements();
        this.ensureCapacity(coverage);
        for (Map.Entry<AbstractInsnNode, Instruction> entry : this.instructions.entrySet()) {
            if (this.ignored.contains(entry.getKey())) continue;
            Instruction instruction = entry.getValue();
            coverage.increment(instruction.getInstructionCounter(), instruction.getBranchCounter(), instruction.getLine());
        }
        coverage.incrementMethodCounter();
    }

    private void applyMerges() {
        for (Map.Entry<AbstractInsnNode, AbstractInsnNode> entry : this.merged.entrySet()) {
            AbstractInsnNode node = entry.getKey();
            Instruction instruction = this.instructions.get(node);
            AbstractInsnNode representativeNode = this.findRepresentative(node);
            this.ignored.add(node);
            this.instructions.put(representativeNode, this.instructions.get(representativeNode).merge(instruction));
            entry.setValue(representativeNode);
        }
        for (Map.Entry<AbstractInsnNode, AbstractInsnNode> entry : this.merged.entrySet()) {
            this.instructions.put(entry.getKey(), this.instructions.get(entry.getValue()));
        }
    }

    private void applyReplacements() {
        for (Map.Entry<AbstractInsnNode, Set<AbstractInsnNode>> entry : this.replacements.entrySet()) {
            Set<AbstractInsnNode> replacements = entry.getValue();
            ArrayList<Instruction> newBranches = new ArrayList<Instruction>(replacements.size());
            for (AbstractInsnNode b : replacements) {
                newBranches.add(this.instructions.get(b));
            }
            AbstractInsnNode node = entry.getKey();
            this.instructions.put(node, this.instructions.get(node).replaceBranches(newBranches));
        }
    }

    private void ensureCapacity(MethodCoverageImpl coverage) {
        int firstLine = -1;
        int lastLine = -1;
        for (Map.Entry<AbstractInsnNode, Instruction> entry : this.instructions.entrySet()) {
            int line;
            if (this.ignored.contains(entry.getKey()) || (line = entry.getValue().getLine()) == -1) continue;
            if (firstLine > line || lastLine == -1) {
                firstLine = line;
            }
            if (lastLine >= line) continue;
            lastLine = line;
        }
        coverage.ensureCapacity(firstLine, lastLine);
    }

    private AbstractInsnNode findRepresentative(AbstractInsnNode i) {
        AbstractInsnNode r;
        while ((r = this.merged.get(i)) != null) {
            i = r;
        }
        return i;
    }

    @Override
    public void ignore(AbstractInsnNode fromInclusive, AbstractInsnNode toInclusive) {
        for (AbstractInsnNode i = fromInclusive; i != toInclusive; i = i.getNext()) {
            this.ignored.add(i);
        }
        this.ignored.add(toInclusive);
    }

    @Override
    public void merge(AbstractInsnNode i1, AbstractInsnNode i2) {
        if ((i1 = this.findRepresentative(i1)) != (i2 = this.findRepresentative(i2))) {
            this.merged.put(i2, i1);
        }
    }

    @Override
    public void replaceBranches(AbstractInsnNode source, Set<AbstractInsnNode> newTargets) {
        this.replacements.put(source, newTargets);
    }
}

