(set-option :produce-proofs true)
(set-option :proof-check-mode true)
(set-option :model-check-mode true)

(set-logic QF_UF)
(declare-sort U 0)
(declare-fun c1 () Bool)
(declare-fun a () U)
(declare-fun b () U)
(push 1)
(assert (not (= (ite c1 a b) a)))
(assert (not (= (ite c1 a b) b)))
;(@tautology (! (or (not c1) (= (ite c1 a b) a)) :termITE))
;(@tautology (! (or (not (not c1)) (= (ite c1 a b) b)) :termITE))

(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)

(declare-fun c2 () Bool)
(declare-fun c () U)
(push 1)
(assert (not (= (ite c1 a (ite c2 b c)) a)))
(assert (not (= (ite c1 a (ite c2 b c)) b)))
(assert (not (= (ite c1 a (ite c2 b c)) c)))
;(@tautology (! (or (not c1) (= (ite c1 a (ite c2 b c)) a)) :termITE))
;(@tautology (! (or (not (not c1)) (not c2) (= (ite c1 a (ite c2 b c)) b)) :termITE))
;(@tautology (! (or (not (not c1)) (not (not c2)) (= (ite c1 a (ite c2 b c)) c)) :termITE))

(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (ite c1 (ite c2 a b) c) a)))
(assert (not (= (ite c1 (ite c2 a b) c) b)))
(assert (not (= (ite c1 (ite c2 a b) c) c)))
;(@tautology (! (or (not c1) (not c2) (= (ite c1 (ite c2 a b) c) a)) :termITE))
;(@tautology (! (or (not c1) (not (not c2)) (= (ite c1 (ite c2 a b) c) b)) :termITE))
;(@tautology (! (or (not (not c1)) (= (ite c1 (ite c2 a b) c) c)) :termITE))

(check-sat)
(set-option :print-terms-cse false)
(get-proof)
(pop 1)
