(set-option :produce-proofs true)
(set-option :proof-check-mode true)
(set-option :model-check-mode true)
(set-option :print-terms-cse false)

(set-logic QF_UFLIRA)
(declare-fun p () Bool)
(declare-fun q () Bool)
(declare-fun a () Int)
(declare-fun b () Int)
(declare-fun c () Int)

(push 1)
(assert (xor p q p q))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (< a b c a))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (<= a b c a))
(assert (distinct a b))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (= a b c))
(assert (distinct a c))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (not (= (* (/ a 1 2 3 4) 24) a)))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (> (* (div a 1 2 3 4) 24) a))
(check-sat)
(get-proof)
(pop 1)


(push 1)
(assert (= a (div b 0)))
(assert (= (div b 0) c))
(assert (not (= a c)))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (= a (mod b 0)))
(assert (= (mod b 0) c))
(assert (not (= a c)))
(check-sat)
(get-proof)
(pop 1)

(push 1)
(assert (= a (/ b 0)))
(assert (= (/ b 0) c))
(assert (not (= a c)))
(check-sat)
(get-proof)
(pop 1)
