//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by validation-gen. DO NOT EDIT.

package k8suuid

import (
	context "context"
	fmt "fmt"

	operation "k8s.io/apimachinery/pkg/api/operation"
	safe "k8s.io/apimachinery/pkg/api/safe"
	validate "k8s.io/apimachinery/pkg/api/validate"
	field "k8s.io/apimachinery/pkg/util/validation/field"
	testscheme "k8s.io/code-generator/cmd/validation-gen/testscheme"
)

func init() { localSchemeBuilder.Register(RegisterValidations) }

// RegisterValidations adds validation functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterValidations(scheme *testscheme.Scheme) error {
	// type MyType
	scheme.AddValidationFunc((*MyType)(nil), func(ctx context.Context, op operation.Operation, obj, oldObj interface{}) field.ErrorList {
		switch op.Request.SubresourcePath() {
		case "/":
			return Validate_MyType(ctx, op, nil /* fldPath */, obj.(*MyType), safe.Cast[*MyType](oldObj))
		}
		return field.ErrorList{field.InternalError(nil, fmt.Errorf("no validation found for %T, subresource: %v", obj, op.Request.SubresourcePath()))}
	})
	return nil
}

// Validate_MyType validates an instance of MyType according
// to declarative validation rules in the API schema.
func Validate_MyType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *MyType) (errs field.ErrorList) {
	// field MyType.TypeMeta has no validation

	// field MyType.UUIDField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalValue(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.UUID(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("uuidField"), &obj.UUIDField, safe.Field(oldObj, func(oldObj *MyType) *string { return &oldObj.UUIDField }), oldObj != nil)...)

	// field MyType.UUIDPtrField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *string, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call field-attached validations
			earlyReturn := false
			if e := validate.OptionalPointer(ctx, op, fldPath, obj, oldObj); len(e) != 0 {
				earlyReturn = true
			}
			if earlyReturn {
				return // do not proceed
			}
			errs = append(errs, validate.UUID(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("uuidPtrField"), obj.UUIDPtrField, safe.Field(oldObj, func(oldObj *MyType) *string { return oldObj.UUIDPtrField }), oldObj != nil)...)

	// field MyType.UUIDTypedefField
	errs = append(errs,
		func(fldPath *field.Path, obj, oldObj *UUIDStringType, oldValueCorrelated bool) (errs field.ErrorList) {
			// don't revalidate unchanged data
			if oldValueCorrelated && op.Type == operation.Update && (obj == oldObj || (obj != nil && oldObj != nil && *obj == *oldObj)) {
				return nil
			}
			// call the type's validation function
			errs = append(errs, Validate_UUIDStringType(ctx, op, fldPath, obj, oldObj)...)
			return
		}(fldPath.Child("uuidTypedefField"), &obj.UUIDTypedefField, safe.Field(oldObj, func(oldObj *MyType) *UUIDStringType { return &oldObj.UUIDTypedefField }), oldObj != nil)...)

	return errs
}

// Validate_UUIDStringType validates an instance of UUIDStringType according
// to declarative validation rules in the API schema.
func Validate_UUIDStringType(ctx context.Context, op operation.Operation, fldPath *field.Path, obj, oldObj *UUIDStringType) (errs field.ErrorList) {
	errs = append(errs, validate.UUID(ctx, op, fldPath, obj, oldObj)...)

	return errs
}
