/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "resolv.h"
#include "dnsres.h"

void
dnsres_setservent(struct dnsres_servent_state *state, int f)
{
	if (state->servf == NULL)
		state->servf = fopen(DNSRES_PATH_SERVICES, "r" );
	else
		rewind(state->servf);
	state->stayopen |= f;
}

void
dnsres_endservent(struct dnsres_servent_state *state)
{
	if (state->servf) {
		fclose(state->servf);
		state->servf = NULL;
	}
	state->stayopen = 0;
}

struct dnsres_servent *
dnsres_getservent(struct dnsres_servent_state *state)
{
	char *p, *cp, **q, *endp;
	long l;
	size_t len;

	if (state->servf == NULL &&
	    (state->servf = fopen(DNSRES_PATH_SERVICES, "r" )) == NULL)
		return (NULL);
again:
	if ((p = fgetln(state->servf, &len)) == NULL)
		return (NULL);
	if (p[len-1] == '\n')
		len--;
	if (len >= sizeof(state->line) || len == 0)
		goto again;
	p = memcpy(state->line, p, len);
	state->line[len] = '\0';
	if (*p == '#')
		goto again;
	if ((cp = strchr(p, '#')) != NULL)
		*cp = '\0';
	state->serv.s_name = p;
	p = strpbrk(p, " \t");
	if (p == NULL)
		goto again;
	*p++ = '\0';
	while (*p == ' ' || *p == '\t')
		p++;
	cp = strpbrk(p, ",/");
	if (cp == NULL)
		goto again;
	*cp++ = '\0';
	l = strtol(p, &endp, 10);
	if (endp == p || *endp != '\0' || l < 0 || l > USHRT_MAX)
		goto again;
	state->serv.s_port = htons((in_port_t)l);
	state->serv.s_proto = cp;
	q = state->serv.s_aliases = state->serv_aliases;
	cp = strpbrk(cp, " \t");
	if (cp != NULL)
		*cp++ = '\0';
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &state->serv_aliases[MAXALIASES - 1])
			*q++ = cp;
		cp = strpbrk(cp, " \t");
		if (cp != NULL)
			*cp++ = '\0';
	}
	*q = NULL;
	return (&state->serv);
}
