macro(build_qemu)
  include(ExternalProject)

  ExternalProject_Add(
    qemu
    PREFIX ${CMAKE_CURRENT_SOURCE_DIR}/qemu
    URL https://download.qemu.org/qemu-6.0.0.tar.bz2
    URL_MD5 f3d5455f8be87a36d106463a50882f9d
    CONFIGURE_COMMAND
      ${CMAKE_CURRENT_SOURCE_DIR}/qemu/src/qemu/configure
      --prefix=${CMAKE_INSTALL_FULL_DATAROOTDIR}/nemu/qemu
      --enable-system
      --disable-docs
      --disable-guest-agent
      --enable-pie
      --disable-debug-info
      --disable-debug-tcg
      --disable-gnutls
      --disable-nettle
      --disable-gcrypt
      --disable-sdl
      --disable-sdl-image
      --disable-gtk
      --disable-vte
      --disable-curses
      --enable-vnc
      --enable-vnc-jpeg
      --enable-vnc-png
      --disable-vnc-sasl
      --enable-virtfs
      --disable-xen
      --disable-xen-pci-passthrough
      --disable-brlapi
      --enable-curl
      --enable-fdt
      --enable-kvm
      --disable-rdma
      --disable-vde
      --disable-netmap
      --enable-linux-aio
      --enable-cap-ng
      --enable-attr
      --enable-vhost-net
      --enable-vhost-crypto
      --enable-vhost-kernel
      --enable-vhost-user
      --enable-spice
      --disable-rbd
      --disable-libiscsi
      --disable-libnfs
      --disable-smartcard
      --enable-libusb
      --enable-live-block-migration
      --enable-usb-redir
      --disable-lzo
      --disable-snappy
      --enable-bzip2
      --disable-lzfse
      --enable-seccomp
      --enable-coroutine-pool
      --disable-glusterfs
      --enable-tpm
      --disable-libssh
      --disable-numa
      --enable-libxml2
      --disable-tcmalloc
      --disable-jemalloc
      --disable-opengl
      --disable-virglrenderer
      --disable-xfsctl
      --disable-qom-cast-debug
      --enable-tools
      --enable-bochs
      --enable-cloop
      --enable-dmg
      --enable-qcow1
      --enable-vdi
      --enable-vvfat
      --enable-vvfat
      --enable-qed
      --enable-parallels
      --disable-capstone
      --disable-debug-mutex
      --disable-libpmem
      --disable-xkbcommon
      --target-list=${NM_QEMU_TARGET_LIST}
    INSTALL_COMMAND
      DESTDIR=${CMAKE_CURRENT_BINARY_DIR}/qemu
      ${CMAKE_MAKE_PROGRAM}
      install)

endmacro(build_qemu)
