/*****************************************************************************
 * h264.c: H264 packetizer unit testing
 *****************************************************************************
 * Copyright (C) 2019 VideoLabs, VideoLAN and VLC Authors
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <vlc/vlc.h>
#include "../../../lib/libvlc_internal.h"
#include "../../libvlc/test.h"

#include "packetizer.h"

/* 16x16, keyint 25, 50 frames */
const uint8_t test_samples_raw_h264[] = {
  0x00, 0x00, 0x00, 0x01, 0x67, 0xf4, 0x00, 0x0a, 0x91, 0x9b, 0x2b, 0xd0,
  0x80, 0x00, 0x00, 0x03, 0x00, 0x80, 0x00, 0x00, 0x19, 0x07, 0x89, 0x12,
  0xcb, 0x00, 0x00, 0x00, 0x01, 0x68, 0xeb, 0xec, 0x44, 0x84, 0x40, 0x00,
  0x00, 0x01, 0x65, 0x88, 0x84, 0x00, 0x37, 0xff, 0xfe, 0xf5, 0xdb, 0xf3,
  0x2c, 0xac, 0x66, 0x67, 0xff, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0x24,
  0x6c, 0x46, 0xff, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9e, 0x42,
  0x78, 0x9f, 0xff, 0xdd, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0x61,
  0x74, 0x4b, 0xff, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0x63,
  0x6a, 0x4b, 0xff, 0xe0, 0x81, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0x68,
  0x49, 0xa8, 0x41, 0x68, 0x99, 0x4c, 0x08, 0x4f, 0xff, 0xfe, 0xc1, 0x00,
  0x00, 0x00, 0x01, 0x41, 0x9e, 0x86, 0x45, 0x11, 0x2c, 0x4f, 0xdb, 0x81,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0xa5, 0x74, 0x4b, 0xff, 0xe0, 0x81,
  0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0xa7, 0x6a, 0x44, 0xff, 0xdb, 0x80,
  0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0xac, 0x49, 0xa8, 0x41, 0x6c, 0x99,
  0x4c, 0x08, 0x6f, 0xff, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9e,
  0xca, 0x45, 0x15, 0x2c, 0x7f, 0xd6, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x9e, 0xe9, 0x74, 0x45, 0xff, 0xda, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x9e, 0xeb, 0x6a, 0x47, 0xff, 0xd6, 0x80, 0x00, 0x00, 0x00, 0x01, 0x41,
  0x9a, 0xf0, 0x49, 0xa8, 0x41, 0x6c, 0x99, 0x4c, 0x08, 0x21, 0xff, 0xfe,
  0xe1, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9f, 0x0e, 0x45, 0x15, 0x2c, 0x2f,
  0xff, 0xca, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0x2d, 0x74, 0x42,
  0x7f, 0xd1, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0x2f, 0x6a, 0x42,
  0xff, 0xca, 0x80, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9b, 0x34, 0x49, 0xa8,
  0x41, 0x6c, 0x99, 0x4c, 0x08, 0x25, 0xff, 0xfe, 0xe0, 0x00, 0x00, 0x00,
  0x01, 0x41, 0x9f, 0x52, 0x45, 0x15, 0x2c, 0x3b, 0xff, 0xc1, 0x81, 0x00,
  0x00, 0x00, 0x01, 0x01, 0x9f, 0x71, 0x74, 0x43, 0x3f, 0xc7, 0x80, 0x00,
  0x00, 0x00, 0x01, 0x01, 0x9f, 0x73, 0x6a, 0x43, 0x7f, 0xc4, 0x80, 0x00,
  0x00, 0x00, 0x01, 0x41, 0x9b, 0x78, 0x49, 0xa8, 0x41, 0x6c, 0x99, 0x4c,
  0x08, 0x29, 0xff, 0xfe, 0xe1, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9f, 0x96,
  0x45, 0x15, 0x2c, 0x10, 0xff, 0xba, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x9f, 0xb5, 0x74, 0x43, 0xbf, 0xc1, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x9f, 0xb7, 0x6a, 0x41, 0x0f, 0xba, 0x81, 0x00, 0x00, 0x00, 0x01, 0x67,
  0xf4, 0x00, 0x0a, 0x91, 0x9b, 0x2b, 0xd0, 0x80, 0x00, 0x00, 0x03, 0x00,
  0x80, 0x00, 0x00, 0x19, 0x07, 0x89, 0x12, 0xcb, 0x00, 0x00, 0x00, 0x01,
  0x68, 0xeb, 0xec, 0x44, 0x84, 0x40, 0x00, 0x00, 0x01, 0x65, 0x88, 0x82,
  0x00, 0x04, 0x7f, 0xfe, 0xf6, 0xfc, 0xfc, 0x0a, 0x6d, 0x53, 0x09, 0xff,
  0xc0, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0x24, 0x6c, 0x41, 0x7f, 0xfe,
  0xf1, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9e, 0x42, 0x78, 0x82, 0x5f, 0xb3,
  0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0x61, 0x74, 0x41, 0x2f, 0xb3,
  0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0x63, 0x6a, 0x41, 0x2f, 0xb3,
  0x81, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0x68, 0x49, 0xa8, 0x41, 0x68,
  0x99, 0x4c, 0x08, 0x31, 0xff, 0xfe, 0xf0, 0x00, 0x00, 0x00, 0x01, 0x41,
  0x9e, 0x86, 0x45, 0x11, 0x2c, 0x14, 0xff, 0xa6, 0x80, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x9e, 0xa5, 0x74, 0x41, 0x3f, 0xab, 0x81, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x9e, 0xa7, 0x6a, 0x41, 0x3f, 0xab, 0x80, 0x00, 0x00, 0x00,
  0x01, 0x41, 0x9a, 0xac, 0x49, 0xa8, 0x41, 0x6c, 0x99, 0x4c, 0x08, 0x33,
  0xff, 0xfe, 0xf1, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9e, 0xca, 0x45, 0x15,
  0x2c, 0x16, 0xff, 0x9c, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0xe9,
  0x74, 0x41, 0x4f, 0xa6, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9e, 0xeb,
  0x6a, 0x41, 0x5f, 0xa1, 0x81, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9a, 0xf0,
  0x49, 0xa8, 0x41, 0x6c, 0x99, 0x4c, 0x08, 0x35, 0xff, 0xfe, 0xf1, 0x00,
  0x00, 0x00, 0x01, 0x41, 0x9f, 0x0e, 0x45, 0x15, 0x2c, 0x17, 0xff, 0x97,
  0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0x2d, 0x74, 0x41, 0x6f, 0x9c,
  0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0x2f, 0x6a, 0x41, 0x6f, 0x9c,
  0x80, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9b, 0x34, 0x49, 0xa8, 0x41, 0x6c,
  0x99, 0x4c, 0x08, 0x35, 0xff, 0xfe, 0xf1, 0x00, 0x00, 0x00, 0x01, 0x41,
  0x9f, 0x52, 0x45, 0x15, 0x2c, 0x19, 0xff, 0x8c, 0x80, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x9f, 0x71, 0x74, 0x41, 0x7f, 0x97, 0x80, 0x00, 0x00, 0x00,
  0x01, 0x01, 0x9f, 0x73, 0x6a, 0x41, 0x8f, 0x92, 0x81, 0x00, 0x00, 0x00,
  0x01, 0x41, 0x9b, 0x78, 0x49, 0xa8, 0x41, 0x6c, 0x99, 0x4c, 0x08, 0x33,
  0xff, 0xfe, 0xf1, 0x00, 0x00, 0x00, 0x01, 0x41, 0x9f, 0x96, 0x45, 0x15,
  0x2c, 0x1a, 0xff, 0x86, 0x81, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0xb5,
  0x74, 0x41, 0x8f, 0x92, 0x80, 0x00, 0x00, 0x00, 0x01, 0x01, 0x9f, 0xb7,
  0x6a, 0x41, 0x9f, 0x8c, 0x80
};
const size_t test_samples_raw_h264_len = 761;

int main(void)
{
    test_init();

    libvlc_instance_t *vlc = libvlc_new(0, NULL);
    if(!vlc)
        return 1;

    struct params_s params;
    params.vlc = vlc;
    params.obj = VLC_OBJECT(vlc->p_libvlc_int);
    params.codec = VLC_CODEC_H264;
    params.i_rate_num = 0;
    params.i_rate_den = 0;
    params.i_frame_count = 2*25;
    params.b_extra = true;

    params.i_read_size = 500;
    RUN("block 500", test_packetize,
        test_samples_raw_h264, test_samples_raw_h264_len, 0);

    params.i_rate_num = 60000;
    params.i_rate_den = 1001;
    params.i_read_size = 8;
    RUN("block 8", test_packetize,
        test_samples_raw_h264, test_samples_raw_h264_len, 0);

    params.i_frame_count = 1*25;
    params.i_read_size = 500;
    RUN("skip 1st Iframe", test_packetize,
        test_samples_raw_h264 + 10, test_samples_raw_h264_len - 10, 0);

    libvlc_release(vlc);
    return 0;
}
