/* $Id: op_plugbase.h,v 1.5 2004/03/16 04:18:20 andrewbaker Exp $ */
/*
** Copyright (C) 2001-2002 Andrew R. Baker <andrewb@snort.org>
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __OP_PLUGBASE_H__
#define __OP_PLUGBASE_H__

#include "plugbase.h"

/*------------------------ Data Structures -------------------------*/
typedef struct _OutputPlugin
{
    /* Generic Data */
    char *name;
    char *type;
    int configured;     /* has setup been run */
    int started;        /* are we started */
    /* Plugin specific data */
    void *data; 
    /* Functions */
    int (*setupFunc)(struct _OutputPlugin *, char *);
    int (*exitFunc)(struct _OutputPlugin *);
    int (*startFunc)(struct _OutputPlugin *, void *);  
    int (*stopFunc)(struct _OutputPlugin *); 
    int (*outputFunc)(void *, void *); /* standard output function */
    int (*logConfigFunc)(struct _OutputPlugin *);
} OutputPlugin;

typedef struct _OutputPluginListNode
{
    OutputPlugin *outputPlugin;
    struct _OutputPluginListNode *next;
} OutputPluginListNode;

/* -------------------- Exported Variables -----------------------*/
extern OutputPluginListNode *outputPlugins;


/*------------------------ Global Functions ------------------------*/
void LoadOutputPlugins();
OutputPlugin *RegisterOutputPlugin(char *, char *);
int AddOutputPlugin(OutputPluginListNode **list, OutputPlugin *op); 
void CallOutputPlugins(OutputPluginListNode *list, void *data);
OutputPlugin *LookupOutputPlugin(char *name);
void FreeOutputPluginList(OutputPluginListNode *, int);


/*-------------------- Output Plugin Functions ---------------------*/
int OutputPluginSetup(OutputPlugin *, char *);
int OutputPluginExit(OutputPlugin *);
int OutputPluginStart(OutputPlugin *, void *);
int OutputPluginStop(OutputPlugin *);
int OutputPluginRestart(OutputPlugin *, void *);
void OutputPluginFree(OutputPlugin *);

#endif /* __OP_PLUGBASE_H__ */
