// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package main

import (
	"bytes"
	"flag"
	"go/format"
	"io/ioutil"
	"os"
	"text/template"
)

var Template = template.Must(template.New("licenseheader").Parse(`
{{ $t := "` + "`" + `" }}
{{ .License }}

// Code generated by beats/dev-tools/cmd/license/license_generate.go - DO NOT EDIT.

package licenses

import "fmt"

{{ range $key, $value := .Licenses }}
var {{ $key }} =  {{$t}}
{{ $value }}{{$t}}
{{ end -}}

func Find(name string) (string, error) {
	switch name {
{{ range $key, $value := .Licenses }}
	case "{{ $key }}":
		return {{ $key }}, nil
{{- end -}}
	}
	return "", fmt.Errorf("unknown license: %s", name)
}
`))

var output string

type data struct {
	License  string
	Licenses map[string]string
}

func init() {
	flag.StringVar(&output, "out", "license_header.go", "output file")
}

func main() {
	Headers := make(map[string]string)
	content, err := ioutil.ReadFile("APACHE-LICENSE-2.0-header.txt")
	if err != nil {
		panic("could not read ASL2 license.")
	}
	Headers["ASL2"] = string(content)

	content, err = ioutil.ReadFile("ELASTIC-LICENSE-header.txt")
	if err != nil {
		panic("could not read Elastic license.")
	}
	Headers["Elastic"] = string(content)

	var buf bytes.Buffer
	Template.Execute(&buf, data{
		License:  Headers["ASL2"],
		Licenses: Headers,
	})

	bs, err := format.Source(buf.Bytes())
	if err != nil {
		panic(err)
	}

	if output == "-" {
		os.Stdout.Write(bs)
	} else {
		ioutil.WriteFile(output, bs, 0640)
	}
}
