/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.scalar.Scalar;

public final class HermitianRank2Update
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static void invoke(double[] data, int firstColumn, int columnLimit, double[] vector1, double[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            double tmpVal1j = vector1[j];
            double tmpVal2j = vector2[j];
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                int n = tmpIndex++;
                data[n] = data[n] - (vector2[i] * tmpVal1j + vector1[i] * tmpVal2j);
            }
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int firstColumn, int columnLimit, N[] vector1, N[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            Scalar tmpVal1j = (Scalar)vector1[j].conjugate();
            Scalar tmpVal2j = (Scalar)vector2[j].conjugate();
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                data[tmpIndex] = (Scalar)data[tmpIndex].subtract(vector2[i].multiply(tmpVal1j).add(vector1[i].multiply(tmpVal2j))).get();
                ++tmpIndex;
            }
        }
    }
}

