/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;

public final class SubstituteForwards
implements ArrayOperation {
    public static int THRESHOLD = 64;

    public static void invoke(double[] data, int structure, int first, int limit, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        double[] bodyRow = new double[diagDim];
        for (int i = 0; i < diagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                bodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            for (int s = first; s < limit; ++s) {
                int j;
                int colBaseIndex = s * structure;
                double tmpVal = PrimitiveMath.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal += bodyRow[j] * data[j + colBaseIndex];
                    ++j;
                }
                tmpVal = identity ? (i == s ? PrimitiveMath.ONE - tmpVal : -tmpVal) : data[i + colBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i + colBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(double[][] data, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int limit = data[0].length;
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        double[] bodyRow = new double[diagDim];
        for (int i = 0; i < diagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                bodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            for (int s = 0; s < limit; ++s) {
                int j;
                double tmpVal = PrimitiveMath.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal += bodyRow[j] * data[j][s];
                    ++j;
                }
                tmpVal = identity ? (i == s ? PrimitiveMath.ONE - tmpVal : -tmpVal) : data[i][s] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i][s] = tmpVal;
            }
        }
    }

    public static void invoke(float[] data, int structure, int first, int limit, Access2D<?> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        float[] bodyRow = new float[diagDim];
        for (int i = 0; i < diagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                bodyRow[j] = conjugated ? body.floatValue(j, i) : body.floatValue(i, j);
            }
            for (int s = first; s < limit; ++s) {
                int j;
                int colBaseIndex = s * structure;
                float tmpVal = 0.0f;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal += bodyRow[j] * data[j + colBaseIndex];
                    ++j;
                }
                tmpVal = identity ? (i == s ? 1.0f - tmpVal : -tmpVal) : data[i + colBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= bodyRow[i];
                }
                data[i + colBaseIndex] = tmpVal;
            }
        }
    }

    public static <N extends Scalar<N>> void invoke(N[] data, int structure, int first, int limit, Access2D<N> body, boolean unitDiagonal, boolean conjugated, boolean identity, Scalar.Factory<N> scalar) {
        int diagDim = MissingMath.toMinIntExact(body.countRows(), body.countColumns());
        Scalar[] bodyRow = (Scalar[])scalar.newArrayInstance(diagDim);
        for (int i = 0; i < diagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                bodyRow[j] = conjugated ? (Scalar)((Scalar)((Scalar)body.get(j, i)).conjugate()).get() : (Scalar)body.get(i, j);
            }
            for (int s = first; s < limit; ++s) {
                int j;
                int colBaseIndex = s * structure;
                Scalar<N> tmpVal = scalar.zero();
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal = tmpVal.add((Scalar)bodyRow[j].multiply(data[j + colBaseIndex]));
                    ++j;
                }
                tmpVal = identity ? (i == s ? scalar.one().subtract(tmpVal) : (Scalar<N>)tmpVal.negate()) : data[i + colBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = tmpVal.divide(bodyRow[i]);
                }
                data[i + colBaseIndex] = (Scalar)tmpVal.get();
            }
        }
    }
}

