/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access1D;

public final class LinearFunction<N extends Comparable<N>>
implements MultiaryFunction.TwiceDifferentiable<N>,
MultiaryFunction.Linear<N> {
    private final MatrixStore<N> myCoefficients;

    public static LinearFunction<ComplexNumber> makeComplex(Access1D<?> coefficients) {
        return new LinearFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.rows(coefficients));
    }

    public static LinearFunction<ComplexNumber> makeComplex(int arity) {
        return new LinearFunction<ComplexNumber>((MatrixStore)GenericStore.COMPLEX.make(1, arity));
    }

    public static LinearFunction<Double> makePrimitive(Access1D<?> coefficients) {
        return new LinearFunction<Double>((MatrixStore)Primitive64Store.FACTORY.rows(coefficients));
    }

    public static LinearFunction<Double> makePrimitive(int arity) {
        return new LinearFunction<Double>((MatrixStore)Primitive64Store.FACTORY.make(1, arity));
    }

    public static LinearFunction<RationalNumber> makeRational(Access1D<?> coefficients) {
        return new LinearFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.rows(coefficients));
    }

    public static LinearFunction<RationalNumber> makeRational(int arity) {
        return new LinearFunction<RationalNumber>((MatrixStore)GenericStore.RATIONAL.make(1, arity));
    }

    public static <N extends Comparable<N>> LinearFunction<N> wrap(PhysicalStore<N> coefficients) {
        return new LinearFunction<N>(coefficients);
    }

    LinearFunction(MatrixStore<N> coefficients) {
        if (!coefficients.isVector()) {
            throw new IllegalArgumentException("Must be a  vector!");
        }
        this.myCoefficients = coefficients;
    }

    @Override
    public int arity() {
        return Math.toIntExact(this.myCoefficients.count());
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.getLinearFactors();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.factory().makeZero(this.arity(), this.arity());
    }

    @Override
    public MatrixStore<N> getLinearFactors() {
        if (this.myCoefficients.countRows() == 1L) {
            return this.myCoefficients.transpose();
        }
        return this.myCoefficients;
    }

    @Override
    public N invoke(Access1D<N> arg) {
        PhysicalStore preallocated = (PhysicalStore)this.myCoefficients.physical().make(1L, 1L);
        this.myCoefficients.multiply(arg, preallocated);
        return preallocated.get(0L, 0L);
    }

    @Override
    public PhysicalStore<N> linear() {
        return (PhysicalStore)this.myCoefficients;
    }

    PhysicalStore.Factory<N, ?> factory() {
        return this.myCoefficients.physical();
    }
}

