/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.operation;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.function.IntSupplier;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.DOT;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;
import org.ojalgo.concurrent.ProcessingService;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Structure2D;

public class MultiplyLeft
implements MatrixOperation {
    public static IntSupplier PARALLELISM = Parallelism.THREADS;
    public static int THRESHOLD = 32;
    private static final DivideAndConquer.Divider DIVIDER = ProcessingService.INSTANCE.divider();

    public static <N extends Scalar<N>> Generic<N> newGeneric(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMxN_MT(org.ojalgo.scalar.Scalar[] org.ojalgo.structure.Access1D int org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        if (columns == 1L) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMx1(org.ojalgo.scalar.Scalar[] org.ojalgo.structure.Access1D int org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        if (rows == 1L) {
            return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V, fill1xN(org.ojalgo.scalar.Scalar[] org.ojalgo.structure.Access1D int org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
        }
        return (Generic<Scalar>)LambdaMetafactory.metafactory(null, null, null, ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V, fillMxN(org.ojalgo.scalar.Scalar[] org.ojalgo.structure.Access1D int org.ojalgo.scalar.Scalar[] org.ojalgo.scalar.Scalar$Factory ), ([Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/structure/Access1D;I[Lorg/ojalgo/scalar/Scalar;Lorg/ojalgo/scalar/Scalar$Factory;)V)();
    }

    public static Primitive32 newPrimitive32(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return MultiplyLeft::fillMxN_MT;
        }
        if (columns == 1L) {
            return MultiplyLeft::fillMx1;
        }
        if (rows == 1L) {
            return MultiplyLeft::fill1xN;
        }
        return MultiplyLeft::fillMxN;
    }

    public static Primitive64 newPrimitive64(long rows, long columns) {
        if (rows > (long)THRESHOLD && columns > (long)THRESHOLD) {
            return MultiplyLeft::fillMxN_MT;
        }
        if (rows == 5L && columns == 5L) {
            return MultiplyLeft::fill5x5;
        }
        if (rows == 4L && columns == 4L) {
            return MultiplyLeft::fill4x4;
        }
        if (rows == 3L && columns == 3L) {
            return MultiplyLeft::fill3x3;
        }
        if (rows == 2L && columns == 2L) {
            return MultiplyLeft::fill2x2;
        }
        if (rows == 1L && columns == 1L) {
            return MultiplyLeft::fill1x1;
        }
        if (columns == 1L) {
            return MultiplyLeft::fillMx1;
        }
        if (rows == 10L) {
            return MultiplyLeft::fill0xN;
        }
        if (rows == 9L) {
            return MultiplyLeft::fill9xN;
        }
        if (rows == 8L) {
            return MultiplyLeft::fill8xN;
        }
        if (rows == 7L) {
            return MultiplyLeft::fill7xN;
        }
        if (rows == 6L) {
            return MultiplyLeft::fill6xN;
        }
        if (rows == 1L) {
            return MultiplyLeft::fill1xN;
        }
        return MultiplyLeft::fillMxN;
    }

    private static void base(double[] product, Access1D<?> left, int complexity, double[] right) {
        int nbRows = Math.toIntExact(left.count() / (long)complexity);
        int nbCols = right.length / complexity;
        for (int i = 0; i < nbRows; ++i) {
            for (int c = 0; c < complexity; ++c) {
                for (int j = 0; j < nbCols; ++j) {
                    int n = i + j * nbRows;
                    product[n] = product[n] + left.doubleValue(Structure2D.index(nbRows, i, c)) * right[c + j * complexity];
                }
            }
        }
    }

    static void add1xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int nbCols = right.length / complexity;
        for (int j = 0; j < nbCols; ++j) {
            int n = j;
            product[n] = product[n] + DOT.invoke(left, 0, right, j * complexity, 0, complexity);
        }
    }

    static void add1xN(float[] product, Access1D<?> left, int complexity, float[] right) {
        int nbCols = right.length / complexity;
        for (int j = 0; j < nbCols; ++j) {
            int n = j;
            product[n] = product[n] + DOT.invoke(left, 0, right, j * complexity, 0, complexity);
        }
    }

    static void addMx1(double[] product, Access1D<?> left, int complexity, double[] right) {
        int structure = Math.toIntExact(left.count() / (long)complexity);
        double[] leftColumn = new double[structure];
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, structure);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = left.doubleValue(Structure2D.index(structure, i, c));
            }
            AXPY.invoke(product, 0, right[c], leftColumn, 0, firstInLeftColumn, limitOfLeftColumn);
        }
    }

    static void addMx1(float[] product, Access1D<?> left, int complexity, float[] right) {
        int structure = Math.toIntExact(left.count() / (long)complexity);
        float[] leftColumn = new float[structure];
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, structure);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = left.floatValue(Structure2D.index(structure, i, c));
            }
            AXPY.invoke(product, 0, right[c], leftColumn, 0, firstInLeftColumn, limitOfLeftColumn);
        }
    }

    static <N extends Scalar<N>> void addMx1(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        int structure = Math.toIntExact(left.count() / (long)complexity);
        Scalar[] leftColumn = (Scalar[])scalar.newArrayInstance(structure);
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, structure);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = (Scalar)left.get(Structure2D.index(structure, i, c));
            }
            AXPY.invoke(product, (int)0, right[c], (Scalar[])leftColumn, (int)0, (int)firstInLeftColumn, (int)limitOfLeftColumn);
        }
    }

    static void addMxC(double[] product, int firstColumn, int columnLimit, Access1D<?> left, int complexity, double[] right) {
        int nbRows = Math.toIntExact(left.count() / (long)complexity);
        double[] leftColumn = new double[nbRows];
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, nbRows);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = left.doubleValue(Structure2D.index(nbRows, i, c));
            }
            for (int j = firstColumn; j < columnLimit; ++j) {
                AXPY.invoke(product, j * nbRows, right[c + j * complexity], leftColumn, 0, firstInLeftColumn, limitOfLeftColumn);
            }
        }
    }

    static void addMxC(float[] product, int firstColumn, int columnLimit, Access1D<?> left, int complexity, float[] right) {
        int nbRows = Math.toIntExact(left.count() / (long)complexity);
        float[] leftColumn = new float[nbRows];
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, nbRows);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = left.floatValue(Structure2D.index(nbRows, i, c));
            }
            for (int j = firstColumn; j < columnLimit; ++j) {
                AXPY.invoke(product, j * nbRows, right[c + j * complexity], leftColumn, 0, firstInLeftColumn, limitOfLeftColumn);
            }
        }
    }

    static <N extends Scalar<N>> void addMxC(N[] product, int firstColumn, int columnLimit, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        int nbRows = Math.toIntExact(left.count() / (long)complexity);
        Scalar[] leftColumn = (Scalar[])scalar.newArrayInstance(nbRows);
        for (int c = 0; c < complexity; ++c) {
            int firstInLeftColumn = Structure2D.firstInColumn(left, c, 0);
            int limitOfLeftColumn = Structure2D.limitOfColumn(left, c, nbRows);
            for (int i = firstInLeftColumn; i < limitOfLeftColumn; ++i) {
                leftColumn[i] = (Scalar)left.get(Structure2D.index(nbRows, i, c));
            }
            for (int j = firstColumn; j < columnLimit; ++j) {
                AXPY.invoke(product, (int)(j * nbRows), right[c + j * complexity], (Scalar[])leftColumn, (int)0, (int)firstInLeftColumn, (int)limitOfLeftColumn);
            }
        }
    }

    static void addMxN_MT(double[] product, Access1D<?> left, int complexity, double[] right) {
        MultiplyLeft.divide(0, right.length / complexity, (f, l) -> MultiplyLeft.addMxC(product, f, l, left, complexity, right));
    }

    static void addMxN_MT(float[] product, Access1D<?> left, int complexity, float[] right) {
        MultiplyLeft.divide(0, right.length / complexity, (f, l) -> MultiplyLeft.addMxC(product, f, l, left, complexity, right));
    }

    static <N extends Scalar<N>> void addMxN_MT(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        MultiplyLeft.divide(0, right.length / complexity, (f, l) -> MultiplyLeft.addMxC((Scalar[])product, (int)f, (int)l, (Access1D)left, (int)complexity, (Scalar[])right, (Scalar.Factory)scalar));
    }

    static void divide(int first, int limit, DivideAndConquer.Conquerer conquerer) {
        DIVIDER.parallelism(PARALLELISM).threshold(THRESHOLD).divide(first, limit, conquerer);
    }

    static void fill0xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int tmpRowDim = 10;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            double tmp9J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp9J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
            product[++tmpIndex] = tmp9J;
        }
    }

    static void fill1x1(double[] product, Access1D<?> left, int complexity, double[] right) {
        double tmp00 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            tmp00 += left.doubleValue(c) * right[c];
        }
        product[0] = tmp00;
    }

    static void fill1xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int nbCols = right.length / complexity;
        for (int j = 0; j < nbCols; ++j) {
            product[j] = DOT.invoke(left, 0, right, j * complexity, 0, complexity);
        }
    }

    static void fill1xN(float[] product, Access1D<?> left, int complexity, float[] right) {
        int nbCols = right.length / complexity;
        for (int j = 0; j < nbCols; ++j) {
            product[j] = DOT.invoke(left, 0, right, j * complexity, 0, complexity);
        }
    }

    static <N extends Scalar<N>> void fill1xN(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        int nbCols = right.length / complexity;
        for (int j = 0; j < nbCols; ++j) {
            product[j] = DOT.invoke(left, (int)0, right, (int)(j * complexity), (int)0, (int)complexity, scalar);
        }
    }

    static void fill2x2(double[] product, Access1D<?> left, int complexity, double[] right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 2;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right[tmpIndex];
            double tmpRight1 = right[tmpIndex += complexity];
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp01;
        product[3] = tmp11;
    }

    static void fill3x3(double[] product, Access1D<?> left, int complexity, double[] right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 3;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right[tmpIndex];
            double tmpRight1 = right[tmpIndex += complexity];
            double tmpRight2 = right[tmpIndex += complexity];
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp01;
        product[4] = tmp11;
        product[5] = tmp21;
        product[6] = tmp02;
        product[7] = tmp12;
        product[8] = tmp22;
    }

    static void fill4x4(double[] product, Access1D<?> left, int complexity, double[] right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 4;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right[tmpIndex];
            double tmpRight1 = right[tmpIndex += complexity];
            double tmpRight2 = right[tmpIndex += complexity];
            double tmpRight3 = right[tmpIndex += complexity];
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp01;
        product[5] = tmp11;
        product[6] = tmp21;
        product[7] = tmp31;
        product[8] = tmp02;
        product[9] = tmp12;
        product[10] = tmp22;
        product[11] = tmp32;
        product[12] = tmp03;
        product[13] = tmp13;
        product[14] = tmp23;
        product[15] = tmp33;
    }

    static void fill5x5(double[] product, Access1D<?> left, int complexity, double[] right) {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp40 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp41 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp42 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        double tmp43 = PrimitiveMath.ZERO;
        double tmp04 = PrimitiveMath.ZERO;
        double tmp14 = PrimitiveMath.ZERO;
        double tmp24 = PrimitiveMath.ZERO;
        double tmp34 = PrimitiveMath.ZERO;
        double tmp44 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 5;
            double tmpLeft0 = left.doubleValue(tmpIndex);
            double tmpLeft1 = left.doubleValue(++tmpIndex);
            double tmpLeft2 = left.doubleValue(++tmpIndex);
            double tmpLeft3 = left.doubleValue(++tmpIndex);
            double tmpLeft4 = left.doubleValue(++tmpIndex);
            tmpIndex = c;
            double tmpRight0 = right[tmpIndex];
            double tmpRight1 = right[tmpIndex += complexity];
            double tmpRight2 = right[tmpIndex += complexity];
            double tmpRight3 = right[tmpIndex += complexity];
            double tmpRight4 = right[tmpIndex += complexity];
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp40 += tmpLeft4 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp41 += tmpLeft4 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp42 += tmpLeft4 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
            tmp43 += tmpLeft4 * tmpRight3;
            tmp04 += tmpLeft0 * tmpRight4;
            tmp14 += tmpLeft1 * tmpRight4;
            tmp24 += tmpLeft2 * tmpRight4;
            tmp34 += tmpLeft3 * tmpRight4;
            tmp44 += tmpLeft4 * tmpRight4;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp40;
        product[5] = tmp01;
        product[6] = tmp11;
        product[7] = tmp21;
        product[8] = tmp31;
        product[9] = tmp41;
        product[10] = tmp02;
        product[11] = tmp12;
        product[12] = tmp22;
        product[13] = tmp32;
        product[14] = tmp42;
        product[15] = tmp03;
        product[16] = tmp13;
        product[17] = tmp23;
        product[18] = tmp33;
        product[19] = tmp43;
        product[20] = tmp04;
        product[21] = tmp14;
        product[22] = tmp24;
        product[23] = tmp34;
        product[24] = tmp44;
    }

    static void fill6xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int tmpRowDim = 6;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
        }
    }

    static void fill7xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int tmpRowDim = 7;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
        }
    }

    static void fill8xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int tmpRowDim = 8;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
        }
    }

    static void fill9xN(double[] product, Access1D<?> left, int complexity, double[] right) {
        int tmpRowDim = 9;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmp0J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp1J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp2J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp3J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp4J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp5J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp6J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp7J += left.doubleValue(tmpIndex++) * tmpRightCJ;
                tmp8J += left.doubleValue(tmpIndex++) * tmpRightCJ;
            }
            tmpIndex = j * tmpRowDim;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
        }
    }

    static void fillMx1(double[] product, Access1D<?> left, int complexity, double[] right) {
        Arrays.fill(product, 0.0);
        MultiplyLeft.addMx1(product, left, complexity, right);
    }

    static void fillMx1(float[] product, Access1D<?> left, int complexity, float[] right) {
        Arrays.fill(product, 0.0f);
        MultiplyLeft.addMx1(product, left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMx1(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        Arrays.fill(product, scalar.zero().get());
        MultiplyLeft.addMx1(product, left, (int)complexity, right, scalar);
    }

    static void fillMxN(double[] product, Access1D<?> left, int complexity, double[] right) {
        Arrays.fill(product, 0.0);
        MultiplyLeft.addMxC(product, 0, right.length / complexity, left, complexity, right);
    }

    static void fillMxN(float[] product, Access1D<?> left, int complexity, float[] right) {
        Arrays.fill(product, 0.0f);
        MultiplyLeft.addMxC(product, 0, right.length / complexity, left, complexity, right);
    }

    static <N extends Scalar<N>> void fillMxN(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        Arrays.fill(product, scalar.zero().get());
        MultiplyLeft.addMxC(product, (int)0, (int)(right.length / complexity), left, (int)complexity, right, scalar);
    }

    static void fillMxN_MT(double[] product, Access1D<?> left, int complexity, double[] right) {
        MultiplyLeft.divide(0, Math.toIntExact(left.count() / (long)complexity), (f, l) -> MultiplyLeft.fillRxN(product, f, l, left, complexity, right));
    }

    static void fillMxN_MT(float[] product, Access1D<?> left, int complexity, float[] right) {
        MultiplyLeft.divide(0, Math.toIntExact(left.count() / (long)complexity), (f, l) -> MultiplyLeft.fillRxN(product, f, l, left, complexity, right));
    }

    static <N extends Scalar<N>> void fillMxN_MT(N[] product, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        MultiplyLeft.divide(0, Math.toIntExact(left.count() / (long)complexity), (f, l) -> MultiplyLeft.fillRxN((Scalar[])product, (int)f, (int)l, (Access1D)left, (int)complexity, (Scalar[])right, (Scalar.Factory)scalar));
    }

    static void fillRxN(double[] product, int firstRow, int rowLimit, Access1D<?> left, int complexity, double[] right) {
        int nbCols = right.length / complexity;
        int nbRows = product.length / nbCols;
        double[] leftRow = new double[complexity];
        for (int i = firstRow; i < rowLimit; ++i) {
            for (int c = 0; c < complexity; ++c) {
                leftRow[c] = left.doubleValue(Structure2D.index(nbRows, i, c));
            }
            for (int j = 0; j < nbCols; ++j) {
                product[i + j * nbRows] = DOT.invoke(leftRow, 0, right, j * complexity, 0, complexity);
            }
        }
    }

    static void fillRxN(float[] product, int firstRow, int rowLimit, Access1D<?> left, int complexity, float[] right) {
        int nbCols = right.length / complexity;
        int nbRows = product.length / nbCols;
        float[] leftRow = new float[complexity];
        for (int i = firstRow; i < rowLimit; ++i) {
            for (int c = 0; c < complexity; ++c) {
                leftRow[c] = left.floatValue(Structure2D.index(nbRows, i, c));
            }
            for (int j = 0; j < nbCols; ++j) {
                product[i + j * nbRows] = DOT.invoke(leftRow, 0, right, j * complexity, 0, complexity);
            }
        }
    }

    static <N extends Scalar<N>> void fillRxN(N[] product, int firstRow, int rowLimit, Access1D<N> left, int complexity, N[] right, Scalar.Factory<N> scalar) {
        int nbCols = right.length / complexity;
        int nbRows = product.length / nbCols;
        Scalar[] leftRow = (Scalar[])scalar.newArrayInstance(complexity);
        for (int i = firstRow; i < rowLimit; ++i) {
            for (int c = 0; c < complexity; ++c) {
                leftRow[c] = (Scalar)left.get(Structure2D.index(nbRows, i, c));
            }
            for (int j = 0; j < nbCols; ++j) {
                product[i + j * nbRows] = DOT.invoke((Scalar[])leftRow, (int)0, right, (int)(j * complexity), (int)0, (int)complexity, scalar);
            }
        }
    }

    @FunctionalInterface
    public static interface Primitive64 {
        public void invoke(double[] var1, Access1D<?> var2, int var3, double[] var4);
    }

    @FunctionalInterface
    public static interface Primitive32 {
        public void invoke(float[] var1, Access1D<?> var2, int var3, float[] var4);
    }

    @FunctionalInterface
    public static interface Generic<N extends Scalar<N>> {
        public void invoke(N[] var1, Access1D<N> var2, int var3, N[] var4, Scalar.Factory<N> var5);
    }
}

