/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.ojalgo.ProgrammingError;
import org.ojalgo.series.MappedIndexSeries;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.NumberDefinition;

public final class NumberSeries<N extends Comparable<N>>
extends TreeSeries<N, N, NumberSeries<N>> {
    private static final long serialVersionUID = 1L;

    public NumberSeries() {
    }

    public NumberSeries(Map<? extends N, ? extends N> map) {
        super(map);
    }

    public NumberSeries(SortedMap<N, ? extends N> sortedMap) {
        super(sortedMap);
    }

    public Access1D<N> accessKeys() {
        return Access1D.wrap(new ArrayList(this.keySet()));
    }

    public Access1D<N> accessValues() {
        return Access1D.wrap(new ArrayList(this.values()));
    }

    @Override
    public N get(long key) {
        return (N)this.get(MappedIndexSeries.toKey(key));
    }

    @Override
    public N get(N key) {
        return (N)((Comparable)this.get(key));
    }

    public double invoke(double arg) {
        ProgrammingError.throwForIllegalInvocation();
        return Double.NaN;
    }

    public N invoke(N arg) {
        return this.get(arg);
    }

    @Override
    public double put(N key, double value) {
        Double tmpValue = value;
        Comparable tmpOldValue = super.put(key, tmpValue);
        if (tmpOldValue != null) {
            return NumberDefinition.doubleValue(tmpOldValue);
        }
        return Double.NaN;
    }
}

