/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.text.Format;
import java.text.ParseException;
import org.ojalgo.ProgrammingError;
import org.ojalgo.type.context.GenericContext;
import org.ojalgo.type.context.TypeContext;

public abstract class FormatContext<T>
implements TypeContext<T> {
    public static final boolean NBSP = true;
    private boolean myConfigured = false;
    private final Format myFormat;

    FormatContext(Format format) {
        ProgrammingError.throwIfNull((Object)format);
        this.myFormat = (Format)format.clone();
    }

    @Override
    public final String format(Object object) {
        if (object != null) {
            try {
                if (!this.myConfigured) {
                    this.configureFormat(this.myFormat, object);
                    this.myConfigured = true;
                }
                return this.myFormat.format(object).replace(' ', '\u00a0');
            }
            catch (IllegalArgumentException exception) {
                return this.handleFormatException(this.myFormat, object);
            }
        }
        return null;
    }

    public Format getFormat() {
        return (Format)this.format().clone();
    }

    @Override
    public final T parse(CharSequence string) {
        if (string != null) {
            try {
                return (T)this.myFormat.parseObject(string.toString().replace('\u00a0', ' '));
            }
            catch (ParseException anException) {
                return this.handleParseException(this.myFormat, string.toString());
            }
        }
        return null;
    }

    public final <G> TypeContext<G> withFormat(Format format) {
        return new GenericContext(this, format);
    }

    protected abstract void configureFormat(Format var1, Object var2);

    protected abstract String handleFormatException(Format var1, Object var2);

    protected abstract T handleParseException(Format var1, String var2);

    final Format format() {
        return this.myFormat;
    }

    final boolean isConfigured() {
        return this.myConfigured;
    }
}

