/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

final class FloatFallibleState
implements AggregatorState {
    private float value;
    private boolean seen;
    private boolean failed;

    FloatFallibleState(float init) {
        this.value = init;
    }

    float floatValue() {
        return this.value;
    }

    void floatValue(float value) {
        this.value = value;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    boolean failed() {
        return this.failed;
    }

    void failed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        blocks[offset + 0] = driverContext.blockFactory().newConstantFloatBlockWith(this.value, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantBooleanBlockWith(this.failed, 1);
    }

    public void close() {
    }
}

