/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopFloatAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopFloatAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopFloatGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopFloatAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopFloatGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of floats";
    }
}

