/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public abstract class LuceneQueryEvaluator<T extends Vector.Builder>
implements Releasable {
    private final BlockFactory blockFactory;
    private final ShardConfig[] shards;
    private final List<ShardState> perShardState;

    protected LuceneQueryEvaluator(BlockFactory blockFactory, ShardConfig[] shards) {
        this.blockFactory = blockFactory;
        this.shards = shards;
        this.perShardState = new ArrayList<Object>(Collections.nCopies(shards.length, null));
    }

    public Block executeQuery(Page page) {
        Object block = page.getBlock(0);
        assert (block instanceof DocBlock) : "LuceneQueryExpressionEvaluator expects DocBlock as input";
        DocVector docs = (DocVector)block.asVector();
        try {
            if (docs.singleSegmentNonDecreasing()) {
                return this.evalSingleSegmentNonDecreasing(docs).asBlock();
            }
            return this.evalSlow(docs).asBlock();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Vector evalSingleSegmentNonDecreasing(DocVector docs) throws IOException {
        ShardState shardState = this.shardState(docs.shards().getInt(0));
        SegmentState segmentState = shardState.segmentState(docs.segments().getInt(0));
        int min = docs.docs().getInt(0);
        int max = docs.docs().getInt(docs.getPositionCount() - 1);
        int length = max - min + 1;
        try (T scoreBuilder = this.createVectorBuilder(this.blockFactory, length);){
            if (length == docs.getPositionCount() && length > 1) {
                Vector vector = segmentState.scoreDense(scoreBuilder, min, max);
                return vector;
            }
            Vector vector = segmentState.scoreSparse(scoreBuilder, docs.docs());
            return vector;
        }
    }

    private Vector evalSlow(DocVector docs) throws IOException {
        int[] map = docs.shardSegmentDocMapForwards();
        int prevShard = -1;
        int prevSegment = -1;
        SegmentState segmentState = null;
        try (T scoreBuilder = this.createVectorBuilder(this.blockFactory, docs.getPositionCount());){
            Vector vector;
            block15: {
                for (int i = 0; i < docs.getPositionCount(); ++i) {
                    int shard = docs.shards().getInt(docs.shards().getInt(map[i]));
                    int segment = docs.segments().getInt(map[i]);
                    if (segmentState == null || prevShard != shard || prevSegment != segment) {
                        segmentState = this.shardState(shard).segmentState(segment);
                        segmentState.initScorer(docs.docs().getInt(map[i]));
                        prevShard = shard;
                        prevSegment = segment;
                    }
                    if (segmentState.noMatch) {
                        this.appendNoMatch(scoreBuilder);
                        continue;
                    }
                    segmentState.scoreSingleDocWithScorer(scoreBuilder, docs.docs().getInt(map[i]));
                }
                Vector outOfOrder = scoreBuilder.build();
                try {
                    vector = outOfOrder.filter(docs.shardSegmentDocMapBackwards());
                    if (outOfOrder == null) break block15;
                }
                catch (Throwable throwable) {
                    if (outOfOrder != null) {
                        try {
                            outOfOrder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outOfOrder.close();
            }
            return vector;
        }
    }

    public void close() {
    }

    private ShardState shardState(int shard) throws IOException {
        ShardState shardState = this.perShardState.get(shard);
        if (shardState != null) {
            return shardState;
        }
        shardState = new ShardState(this.shards[shard]);
        this.perShardState.set(shard, shardState);
        return shardState;
    }

    protected abstract ScoreMode scoreMode();

    protected abstract Vector createNoMatchVector(BlockFactory var1, int var2);

    protected abstract T createVectorBuilder(BlockFactory var1, int var2);

    protected abstract void appendMatch(T var1, Scorable var2) throws IOException;

    protected abstract void appendNoMatch(T var1);

    public record ShardConfig(Query query, IndexSearcher searcher) {
    }

    private class ShardState {
        private final Weight weight;
        private final IndexSearcher searcher;
        private final List<SegmentState> perSegmentState;

        ShardState(ShardConfig config) throws IOException {
            this.weight = config.searcher.createWeight(config.query, LuceneQueryEvaluator.this.scoreMode(), 1.0f);
            this.searcher = config.searcher;
            this.perSegmentState = new ArrayList<Object>(Collections.nCopies(this.searcher.getLeafContexts().size(), null));
        }

        SegmentState segmentState(int segment) throws IOException {
            SegmentState segmentState = this.perSegmentState.get(segment);
            if (segmentState != null) {
                return segmentState;
            }
            segmentState = new SegmentState(this.weight, (LeafReaderContext)this.searcher.getLeafContexts().get(segment));
            this.perSegmentState.set(segment, segmentState);
            return segmentState;
        }
    }

    private class SegmentState {
        private final Weight weight;
        private final LeafReaderContext ctx;
        private Scorer scorer;
        private Thread scorerThread;
        private BulkScorer bulkScorer;
        private Thread bulkScorerThread;
        private boolean noMatch;

        private SegmentState(Weight weight, LeafReaderContext ctx) {
            this.weight = weight;
            this.ctx = ctx;
        }

        Vector scoreDense(T scoreBuilder, int min, int max) throws IOException {
            if (this.noMatch) {
                return LuceneQueryEvaluator.this.createNoMatchVector(LuceneQueryEvaluator.this.blockFactory, max - min + 1);
            }
            if (this.bulkScorer == null || Thread.currentThread() != this.bulkScorerThread) {
                this.bulkScorerThread = Thread.currentThread();
                this.bulkScorer = this.weight.bulkScorer(this.ctx);
                if (this.bulkScorer == null) {
                    this.noMatch = true;
                    return LuceneQueryEvaluator.this.createNoMatchVector(LuceneQueryEvaluator.this.blockFactory, max - min + 1);
                }
            }
            try (DenseCollector<Vector.Builder> collector = new DenseCollector<Vector.Builder>(min, max, (Vector.Builder)scoreBuilder, LuceneQueryEvaluator.this::appendNoMatch, (CheckedBiConsumer<Vector.Builder, Scorable, IOException>)((CheckedBiConsumer)LuceneQueryEvaluator.this::appendMatch));){
                this.bulkScorer.score(collector, this.ctx.reader().getLiveDocs(), min, max + 1);
                Vector vector = collector.build();
                return vector;
            }
        }

        Vector scoreSparse(T scoreBuilder, IntVector docs) throws IOException {
            this.initScorer(docs.getInt(0));
            if (this.noMatch) {
                return LuceneQueryEvaluator.this.createNoMatchVector(LuceneQueryEvaluator.this.blockFactory, docs.getPositionCount());
            }
            for (int i = 0; i < docs.getPositionCount(); ++i) {
                this.scoreSingleDocWithScorer(scoreBuilder, docs.getInt(i));
            }
            return scoreBuilder.build();
        }

        private void initScorer(int minDocId) throws IOException {
            if (this.noMatch) {
                return;
            }
            if (this.scorer == null || this.scorerThread != Thread.currentThread() || this.scorer.iterator().docID() > minDocId) {
                this.scorerThread = Thread.currentThread();
                this.scorer = this.weight.scorer(this.ctx);
                if (this.scorer == null) {
                    this.noMatch = true;
                }
            }
        }

        private void scoreSingleDocWithScorer(T builder, int doc) throws IOException {
            if (this.scorer.iterator().docID() == doc) {
                LuceneQueryEvaluator.this.appendMatch(builder, (Scorable)this.scorer);
            } else if (this.scorer.iterator().docID() > doc) {
                LuceneQueryEvaluator.this.appendNoMatch(builder);
            } else if (this.scorer.iterator().advance(doc) == doc) {
                LuceneQueryEvaluator.this.appendMatch(builder, (Scorable)this.scorer);
            } else {
                LuceneQueryEvaluator.this.appendNoMatch(builder);
            }
        }
    }

    static class DenseCollector<U extends Vector.Builder>
    implements LeafCollector,
    Releasable {
        private final U scoreBuilder;
        private final int max;
        private final Consumer<U> appendNoMatch;
        private final CheckedBiConsumer<U, Scorable, IOException> appendMatch;
        private Scorable scorer;
        int next;

        DenseCollector(int min, int max, U scoreBuilder, Consumer<U> appendNoMatch, CheckedBiConsumer<U, Scorable, IOException> appendMatch) {
            this.scoreBuilder = scoreBuilder;
            this.max = max;
            this.next = min;
            this.appendNoMatch = appendNoMatch;
            this.appendMatch = appendMatch;
        }

        public void setScorer(Scorable scorable) {
            this.scorer = scorable;
        }

        public void collect(int doc) throws IOException {
            while (this.next++ < doc) {
                this.appendNoMatch.accept(this.scoreBuilder);
            }
            this.appendMatch.accept(this.scoreBuilder, (Object)this.scorer);
        }

        public Vector build() {
            return this.scoreBuilder.build();
        }

        public void finish() {
            while (this.next++ <= this.max) {
                this.appendNoMatch.accept(this.scoreBuilder);
            }
        }

        public void close() {
            Releasables.closeExpectNoException(this.scoreBuilder);
        }
    }
}

