/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.index.VersionCompatibilityChecks;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class SysTypes
extends Command {
    private final Integer type;

    public SysTypes(Source source, int type) {
        super(source);
        this.type = type;
    }

    protected NodeInfo<SysTypes> info() {
        return NodeInfo.create((Node)this, SysTypes::new, (Object)this.type);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TYPE_NAME"), this.field("DATA_TYPE", DataTypes.INTEGER), this.field("PRECISION", DataTypes.INTEGER), this.keyword("LITERAL_PREFIX"), this.keyword("LITERAL_SUFFIX"), this.keyword("CREATE_PARAMS"), this.field("NULLABLE", DataTypes.SHORT), this.field("CASE_SENSITIVE", DataTypes.BOOLEAN), this.field("SEARCHABLE", DataTypes.SHORT), this.field("UNSIGNED_ATTRIBUTE", DataTypes.BOOLEAN), this.field("FIXED_PREC_SCALE", DataTypes.BOOLEAN), this.field("AUTO_INCREMENT", DataTypes.BOOLEAN), this.keyword("LOCAL_TYPE_NAME"), this.field("MINIMUM_SCALE", DataTypes.SHORT), this.field("MAXIMUM_SCALE", DataTypes.SHORT), this.field("SQL_DATA_TYPE", DataTypes.INTEGER), this.field("SQL_DATETIME_SUB", DataTypes.INTEGER), this.field("NUM_PREC_RADIX", DataTypes.INTEGER), this.field("INTERVAL_PRECISION", DataTypes.INTEGER));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        Stream<DataType> values = SqlDataTypes.types().stream().filter(t -> VersionCompatibilityChecks.isTypeSupportedInVersion(t, session.configuration().version()));
        if (this.type != 0) {
            values = values.filter(t -> this.type.equals(SqlDataTypes.sqlType(t).getVendorTypeNumber()));
        }
        List<List<?>> rows = values.sorted(Comparator.comparing(t -> SqlDataTypes.sqlType(t).getVendorTypeNumber()).thenComparing(t -> SqlDataTypes.sqlType(t).getName())).map(t -> Arrays.asList(t.toString(), SqlDataTypes.sqlType(t).getVendorTypeNumber(), SqlDataTypes.precision(t), "'", "'", null, 2, DataTypes.isString((DataType)t), 3, !DataTypes.isSigned((DataType)t), Boolean.FALSE, Boolean.FALSE, null, SqlDataTypes.metaSqlMinimumScale(t), SqlDataTypes.metaSqlMaximumScale(t), SqlDataTypes.metaSqlDataType(t), SqlDataTypes.metaSqlDateTimeSub(t), SqlDataTypes.metaSqlRadix(t), null)).collect(Collectors.toList());
        listener.onResponse((Object)this.of(session, rows));
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.type.equals(((SysTypes)obj).type);
    }
}

