/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsOptions;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class SentenceBoundaryChunkingSettings
implements ChunkingSettings {
    public static final String NAME = "SentenceBoundaryChunkingSettings";
    private static final ChunkingStrategy STRATEGY = ChunkingStrategy.SENTENCE;
    private static final int MAX_CHUNK_SIZE_LOWER_LIMIT = 20;
    private static final int MAX_CHUNK_SIZE_UPPER_LIMIT = 300;
    private static final Set<String> VALID_KEYS = Set.of(ChunkingSettingsOptions.STRATEGY.toString(), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), ChunkingSettingsOptions.SENTENCE_OVERLAP.toString());
    private static int DEFAULT_OVERLAP = 1;
    protected final int maxChunkSize;
    protected int sentenceOverlap = DEFAULT_OVERLAP;

    public SentenceBoundaryChunkingSettings(Integer maxChunkSize, @Nullable Integer sentenceOverlap) {
        this.maxChunkSize = maxChunkSize;
        this.sentenceOverlap = sentenceOverlap == null ? DEFAULT_OVERLAP : sentenceOverlap;
    }

    public SentenceBoundaryChunkingSettings(StreamInput in) throws IOException {
        this.maxChunkSize = in.readInt();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            this.sentenceOverlap = in.readVInt();
        }
    }

    public static SentenceBoundaryChunkingSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Object[] invalidSettings = map.keySet().stream().filter(key -> !VALID_KEYS.contains(key)).toArray();
        if (invalidSettings.length > 0) {
            validationException.addValidationError(Strings.format((String)"Sentence based chunking settings can not have the following settings: %s", (Object[])new Object[]{Arrays.toString(invalidSettings)}));
        }
        Integer maxChunkSize = ServiceUtils.extractRequiredPositiveIntegerBetween(map, ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), 20, 300, "chunking_settings", validationException);
        Integer sentenceOverlap = ServiceUtils.removeAsType(map, ChunkingSettingsOptions.SENTENCE_OVERLAP.toString(), Integer.class, validationException);
        if (sentenceOverlap == null) {
            sentenceOverlap = DEFAULT_OVERLAP;
        } else if (sentenceOverlap > 1 || sentenceOverlap < 0) {
            validationException.addValidationError(String.valueOf((Object)ChunkingSettingsOptions.SENTENCE_OVERLAP) + "[" + sentenceOverlap + "] must be either 0 or 1");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new SentenceBoundaryChunkingSettings(maxChunkSize, sentenceOverlap);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ChunkingSettingsOptions.STRATEGY.toString(), (Enum)STRATEGY);
        builder.field(ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize);
        builder.field(ChunkingSettingsOptions.SENTENCE_OVERLAP.toString(), this.sentenceOverlap);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.maxChunkSize);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeVInt(this.sentenceOverlap);
        }
    }

    public ChunkingStrategy getChunkingStrategy() {
        return STRATEGY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentenceBoundaryChunkingSettings that = (SentenceBoundaryChunkingSettings)o;
        return Objects.equals(this.maxChunkSize, that.maxChunkSize);
    }

    public int hashCode() {
        return Objects.hash(this.maxChunkSize);
    }
}

