/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.anthropic;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventField;

public class AnthropicStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, StreamingChatCompletionResults.Results> {
    private static final Logger log = LogManager.getLogger(AnthropicStreamingProcessor.class);
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Anthropic chat completions response";

    /*
     * Unable to fully structure code
     */
    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        if (item.isEmpty()) {
            this.upstream().request(1L);
            return;
        }
        results = new ArrayDeque<E>(item.size());
lbl5:
        // 8 sources

        block24: for (ServerSentEvent event : item) {
            if (event.name() != ServerSentEventField.DATA || !event.hasValue()) continue;
            try {
                parser = AnthropicStreamingProcessor.parser(event.value());
                try {
                    var7_9 = eventType = AnthropicStreamingProcessor.eventType(parser);
                    var8_11 = -1;
                    switch (var7_9.hashCode()) {
                        case 96784904: {
                            if (!var7_9.equals("error")) break;
                            var8_11 = 0;
                            break;
                        }
                        case 1536045930: {
                            if (!var7_9.equals("content_block_start")) break;
                            var8_11 = 1;
                            break;
                        }
                        case 1521756864: {
                            if (!var7_9.equals("content_block_delta")) break;
                            var8_11 = 2;
                            break;
                        }
                        case -1214396886: {
                            if (!var7_9.equals("message_start")) break;
                            var8_11 = 3;
                            break;
                        }
                        case -1286099654: {
                            if (!var7_9.equals("message_stop")) break;
                            var8_11 = 4;
                            break;
                        }
                        case -1228685952: {
                            if (!var7_9.equals("message_delta")) break;
                            var8_11 = 5;
                            break;
                        }
                        case 1157928954: {
                            if (!var7_9.equals("content_block_stop")) break;
                            var8_11 = 6;
                            break;
                        }
                        case 3441010: {
                            if (!var7_9.equals("ping")) break;
                            var8_11 = 7;
                        }
                    }
                    switch (var8_11) {
                        case 0: {
                            this.onError(this.parseError(parser));
                            return;
                        }
                        case 1: {
                            this.parseStartBlock(parser).ifPresent((Consumer<StreamingChatCompletionResults.Result>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, offer(E ), (Lorg/elasticsearch/xpack/core/inference/results/StreamingChatCompletionResults$Result;)V)(results));
                            ** break;
                        }
                        case 2: {
                            this.parseMessage(parser).ifPresent((Consumer<StreamingChatCompletionResults.Result>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, offer(E ), (Lorg/elasticsearch/xpack/core/inference/results/StreamingChatCompletionResults$Result;)V)(results));
                            ** break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            AnthropicStreamingProcessor.log.debug("Skipping event type [{}] for line [{}].", (Object)eventType, item);
                            ** break;
                        }
                        default: {
                            AnthropicStreamingProcessor.log.debug("Unknown event type [{}] for line [{}].", (Object)eventType, item);
                            continue block24;
                        }
                    }
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            catch (Exception e) {
                AnthropicStreamingProcessor.log.warn("Failed to parse line {}", (Object)event);
                throw e;
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingChatCompletionResults.Results(results));
        }
    }

    private Throwable parseError(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "error", FAILED_TO_FIND_FIELD_TEMPLATE);
        String type = AnthropicStreamingProcessor.parseString(parser, "type");
        String message = AnthropicStreamingProcessor.parseString(parser, "message");
        RestStatus statusCode = switch (type) {
            case "invalid_request_error" -> RestStatus.BAD_REQUEST;
            case "authentication_error" -> RestStatus.UNAUTHORIZED;
            case "permission_error" -> RestStatus.FORBIDDEN;
            case "not_found_error" -> RestStatus.NOT_FOUND;
            case "request_too_large" -> RestStatus.REQUEST_ENTITY_TOO_LARGE;
            case "rate_limit_error" -> RestStatus.TOO_MANY_REQUESTS;
            default -> RestStatus.INTERNAL_SERVER_ERROR;
        };
        return new ElasticsearchStatusException(message, statusCode, new Object[0]);
    }

    private Optional<StreamingChatCompletionResults.Result> parseStartBlock(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "content_block", FAILED_TO_FIND_FIELD_TEMPLATE);
        String text = AnthropicStreamingProcessor.parseString(parser, "text");
        return text.isBlank() ? Optional.empty() : Optional.of(new StreamingChatCompletionResults.Result(text));
    }

    private Optional<StreamingChatCompletionResults.Result> parseMessage(XContentParser parser) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, "delta", FAILED_TO_FIND_FIELD_TEMPLATE);
        String text = AnthropicStreamingProcessor.parseString(parser, "text");
        return text.isBlank() ? Optional.empty() : Optional.of(new StreamingChatCompletionResults.Result(text));
    }

    private static XContentParser parser(String line) throws IOException {
        return XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, line);
    }

    private static String eventType(XContentParser parser) throws IOException {
        XContentUtils.moveToFirstToken(parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return AnthropicStreamingProcessor.parseString(parser, "type");
    }

    private static String parseString(XContentParser parser, String fieldName) throws IOException {
        XContentUtils.positionParserAtTokenAfterField(parser, fieldName, FAILED_TO_FIND_FIELD_TEMPLATE);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        return parser.text();
    }
}

