/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.alibabacloudsearch.AlibabaCloudSearchAccount;
import org.elasticsearch.xpack.inference.external.alibabacloudsearch.AlibabaCloudSearchResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.AlibabaCloudSearchRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.request.alibabacloudsearch.completion.AlibabaCloudSearchCompletionRequest;
import org.elasticsearch.xpack.inference.external.response.alibabacloudsearch.AlibabaCloudSearchCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionModel;

public class AlibabaCloudSearchCompletionRequestManager
extends AlibabaCloudSearchRequestManager {
    private static final Logger logger = LogManager.getLogger(AlibabaCloudSearchCompletionRequestManager.class);
    private static final ResponseHandler HANDLER = AlibabaCloudSearchCompletionRequestManager.createCompletionHandler();
    private final AlibabaCloudSearchCompletionModel model;
    private final AlibabaCloudSearchAccount account;

    private static ResponseHandler createCompletionHandler() {
        return new AlibabaCloudSearchResponseHandler("alibaba cloud search completion", AlibabaCloudSearchCompletionResponseEntity::fromResponse);
    }

    public static AlibabaCloudSearchCompletionRequestManager of(AlibabaCloudSearchAccount account, AlibabaCloudSearchCompletionModel model, ThreadPool threadPool) {
        return new AlibabaCloudSearchCompletionRequestManager(Objects.requireNonNull(account), Objects.requireNonNull(model), Objects.requireNonNull(threadPool));
    }

    private AlibabaCloudSearchCompletionRequestManager(AlibabaCloudSearchAccount account, AlibabaCloudSearchCompletionModel model, ThreadPool threadPool) {
        super(threadPool, model);
        this.account = Objects.requireNonNull(account);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        List<String> input = inferenceInputs.castTo(ChatCompletionInput.class).getInputs();
        AlibabaCloudSearchCompletionRequest request = new AlibabaCloudSearchCompletionRequest(this.account, input, this.model);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

